/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.http;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.util.MdcHelper;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.filter.AbstractRequestLoggingFilter;

public class HttpHeaderNestedDiagnosticContextFilter
extends AbstractRequestLoggingFilter {
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(HttpHeaderNestedDiagnosticContextFilter.class);
    private String correlationIdHttpHeaderName = "X-Correlation-Id";

    public void setCorrelationIdHttpHeaderName(String correlationIdHttpHeaderName) {
        this.correlationIdHttpHeaderName = correlationIdHttpHeaderName;
    }

    protected String getNestedDiagnosticContextMessage(HttpServletRequest request) {
        String correlationId = null;
        if (this.correlationIdHttpHeaderName != null) {
            correlationId = request.getHeader(this.correlationIdHttpHeaderName);
        }
        if (correlationId == null || correlationId.isEmpty()) {
            correlationId = UUID.randomUUID().toString();
            if (this.correlationIdHttpHeaderName != null) {
                LOG.debug("HTTP-Header {} enth\u00e4lt keine Correlation-ID. Neue Correlation-ID {} erzeugt.", this.correlationIdHttpHeaderName, correlationId);
            } else {
                LOG.debug("Name des HTTP-Header mit Correlation-ID ist nicht definiert. Neue Correlation-ID {} erzeugt.", correlationId);
            }
        } else {
            LOG.debug("\u00dcbernehme Correlation-ID {} aus HTTP-Header {}", correlationId, this.correlationIdHttpHeaderName);
        }
        return correlationId;
    }

    protected void beforeRequest(HttpServletRequest request, String message) {
        LOG.debug(message, new Object[0]);
        MdcHelper.pushKorrelationsId(this.getNestedDiagnosticContextMessage(request));
    }

    protected void afterRequest(HttpServletRequest request, String message) {
        MdcHelper.entferneKorrelationsIds();
        LOG.debug(message, new Object[0]);
    }
}

