/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.util.LogHelper;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class PerformanceLoggingAspect {
    private LogHelper logHelper = new LogHelper(false, false, true, false, false, 0L, LogHelper.erstelleStandardKonverter());

    @Around(value="awfUndAfuKlassen()")
    public Object loggeDauer(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> klasse = pjp.getTarget().getClass();
        Method methode = ((MethodSignature)pjp.getSignature()).getMethod();
        IsyLogger logger = IsyLoggerFactory.getLogger(klasse);
        long startzeit = this.logHelper.ermittleAktuellenZeitpunkt();
        try {
            Object ergebnis = pjp.proceed();
            long dauer = this.ermittleDauer(startzeit);
            this.logHelper.loggeDauer(logger, methode, dauer, true);
            return ergebnis;
        }
        catch (Throwable t) {
            long dauer = this.ermittleDauer(startzeit);
            this.logHelper.loggeDauer(logger, methode, dauer, false);
            throw t;
        }
    }

    @Pointcut(value="execution(* * ..core..Awf*.*(..)) || execution(* * ..core..Afu*.*(..))")
    public void awfUndAfuKlassen() {
    }

    private long ermittleDauer(long startzeit) {
        long endezeit = this.logHelper.ermittleAktuellenZeitpunkt();
        return endezeit - startzeit;
    }
}

