/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.autoconfigure;

import de.bund.bva.isyfact.logging.util.LoggingMethodInterceptor;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableLoadTimeWeaving;

@Configuration
@ConditionalOnProperty(value={"isy.logging.performancelogging.enabled"}, havingValue="true")
@EnableLoadTimeWeaving
public class IsyPerformanceLoggingAutoConfiguration {
    String[] pointcuts = new String[]{"execution(public * *..gui..*Controller.*(..))", "execution(public * *..service..*ServiceImpl.*(..))", "execution(public * *..core..*Impl.*(..))", "execution(public * *..persistence..*DaoImpl.*(..))", "execution(@de.bund.bva.isyfact.logging.annotation.PerformanceLogging * *(..))"};

    @Bean
    public LoggingMethodInterceptor performanceLogInterceptor() {
        LoggingMethodInterceptor interceptor = new LoggingMethodInterceptor();
        interceptor.setLoggeDauer(true);
        interceptor.setLoggeAufruf(false);
        interceptor.setLoggeErgebnis(false);
        interceptor.setLoggeDaten(false);
        interceptor.setLoggeDatenBeiException(false);
        return interceptor;
    }

    @Bean
    public Advisor performanceLogAdvisor(LoggingMethodInterceptor performanceLogInterceptor) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(String.join((CharSequence)" or ", this.pointcuts));
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)performanceLogInterceptor);
        advisor.setOrder(1000);
        return advisor;
    }
}

