/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.util.BeanConverter;
import de.bund.bva.isyfact.logging.util.BeanToMapConverter;
import de.bund.bva.isyfact.logging.util.LogHelper;
import java.lang.reflect.Method;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;

public class LoggingMethodInterceptor
implements MethodInterceptor,
InitializingBean {
    private LogHelper logHelper;
    private boolean loggeAufruf = true;
    private boolean loggeErgebnis = true;
    private boolean loggeDauer = true;
    private boolean loggeDaten = false;
    private boolean loggeDatenBeiException = true;
    private long loggeMaximaleParameterGroesse = 0L;
    private final boolean verwendeStandardKonverter;
    private List<String> converterIncludes;
    private List<String> converterExcludes;

    public LoggingMethodInterceptor() {
        this.verwendeStandardKonverter = true;
    }

    public LoggingMethodInterceptor(List<String> converterIncludes, List<String> converterExcludes) {
        this.verwendeStandardKonverter = false;
        this.converterExcludes = converterExcludes;
        this.converterIncludes = converterIncludes;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> klasse = invocation.getMethod().getDeclaringClass();
        Method methode = invocation.getMethod();
        IsyLogger logger = IsyLoggerFactory.getLogger(klasse);
        this.logHelper.loggeAufruf(logger, methode);
        long startzeit = this.logHelper.ermittleAktuellenZeitpunkt();
        try {
            Object ergebnis = invocation.proceed();
            long dauer = this.ermittleDauer(startzeit);
            this.logHelper.loggeDauer(logger, methode, dauer, true);
            this.logHelper.loggeErgebnis(logger, methode, true, invocation.getArguments(), ergebnis);
            return ergebnis;
        }
        catch (Throwable t) {
            long dauer = this.ermittleDauer(startzeit);
            this.logHelper.loggeDauer(logger, methode, dauer, false);
            this.logHelper.loggeErgebnis(logger, methode, false, invocation.getArguments(), t);
            throw t;
        }
    }

    private long ermittleDauer(long startzeit) {
        long endezeit = this.logHelper.ermittleAktuellenZeitpunkt();
        long dauer = endezeit - startzeit;
        return dauer;
    }

    public void setLoggeAufruf(boolean loggeAufruf) {
        this.loggeAufruf = loggeAufruf;
    }

    public void setLoggeErgebnis(boolean loggeErgebnis) {
        this.loggeErgebnis = loggeErgebnis;
    }

    public void setLoggeDauer(boolean loggeDauer) {
        this.loggeDauer = loggeDauer;
    }

    public void setLoggeDatenBeiException(boolean loggeDatenBeiException) {
        this.loggeDatenBeiException = loggeDatenBeiException;
    }

    public void setLoggeMaximaleParameterGroesse(long loggeMaximaleParameterGroesse) {
        this.loggeMaximaleParameterGroesse = loggeMaximaleParameterGroesse;
    }

    public void afterPropertiesSet() throws Exception {
        BeanConverter beanConverter = this.erstelleBeanConverter();
        this.logHelper = new LogHelper(this.loggeAufruf, this.loggeErgebnis, this.loggeDauer, this.loggeDaten, this.loggeDatenBeiException, this.loggeMaximaleParameterGroesse, beanConverter);
    }

    protected BeanConverter erstelleBeanConverter() {
        if (this.verwendeStandardKonverter) {
            return LogHelper.erstelleStandardKonverter();
        }
        return new BeanToMapConverter(this.converterIncludes, this.converterExcludes);
    }

    public LogHelper getLogHelper() {
        return this.logHelper;
    }

    public void setLoggeDaten(boolean loggeDaten) {
        this.loggeDaten = loggeDaten;
    }
}

