/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.exceptions.LogKonfigurationFehler;
import de.bund.bva.isyfact.logging.impl.IsyLocationAwareLoggerImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public final class IsyLoggerFactory {
    private static final Map<String, IsyLogger> LOGGER_CACHE = new HashMap<String, IsyLogger>();

    private IsyLoggerFactory() {
    }

    public static IsyLogger getLogger(Class<?> klasse) {
        String klassenName = klasse.getName();
        IsyLogger isyLogger = LOGGER_CACHE.get(klassenName);
        if (isyLogger != null) {
            return isyLogger;
        }
        Logger logger = LoggerFactory.getLogger((String)klassenName);
        IsyLoggerFactory.pruefeLoggerImplementierung(logger);
        LocationAwareLogger locationAwareLogger = (LocationAwareLogger)logger;
        isyLogger = new IsyLocationAwareLoggerImpl(locationAwareLogger);
        LOGGER_CACHE.put(klassenName, isyLogger);
        return isyLogger;
    }

    private static void pruefeLoggerImplementierung(Object logger) {
        if (!(logger instanceof LocationAwareLogger)) {
            throw new LogKonfigurationFehler("ISYLO00000", logger.getClass().getName());
        }
    }
}

