/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.exceptions.InterceptionFehler;
import de.bund.bva.isyfact.logging.util.LogHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LoggingMethodInvoker<T> {
    private final IsyLogger logger;
    private final LogHelper helper;
    private final Method methode;
    private final String nachbarsystemName;
    private final String nachbarsystemUrl;
    private final boolean nachbarsystemAufruf;

    public LoggingMethodInvoker(Method methode, IsyLogger logger, boolean loggeAufruf, boolean loggeErgebnis, boolean loggeDauer, boolean loggeDaten, boolean loggeDatenBeiException, long loggeMaximaleParameterGroesse) {
        this.methode = methode;
        this.logger = logger;
        this.helper = new LogHelper(loggeAufruf, loggeErgebnis, loggeDauer, loggeDaten, loggeDatenBeiException, loggeMaximaleParameterGroesse);
        this.nachbarsystemName = null;
        this.nachbarsystemUrl = null;
        this.nachbarsystemAufruf = false;
    }

    public LoggingMethodInvoker(Method methode, IsyLogger logger, boolean loggeAufruf, boolean loggeErgebnis, boolean loggeDauer, boolean loggeDaten, boolean loggeDatenBeiException, long loggeMaximaleParameterGroesse, String nachbarsystemName, String nachbarsystemUrl) {
        this.methode = methode;
        this.logger = logger;
        this.helper = new LogHelper(loggeAufruf, loggeErgebnis, loggeDauer, loggeDaten, loggeDatenBeiException, loggeMaximaleParameterGroesse);
        this.nachbarsystemName = nachbarsystemName;
        this.nachbarsystemUrl = nachbarsystemUrl;
        this.nachbarsystemAufruf = true;
    }

    public T fuehreMethodeAus(Object ziel, Object ... parameter) throws IllegalAccessException, InvocationTargetException {
        boolean aufrufErfolgreich = false;
        this.erstelleLogVorAuruf();
        long startzeit = 0L;
        Object ergebnis = null;
        try {
            startzeit = this.helper.ermittleAktuellenZeitpunkt();
            ergebnis = this.methode.invoke(ziel, parameter);
            aufrufErfolgreich = true;
            Object object = ergebnis;
            return (T)object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            ergebnis = e;
            throw e;
        }
        catch (ClassCastException e) {
            ergebnis = new InterceptionFehler("ISYLO01000", e, this.methode.getName());
            throw e;
        }
        finally {
            long endezeit = this.helper.ermittleAktuellenZeitpunkt();
            long dauer = endezeit - startzeit;
            this.erstelleLogNachAufruf(aufrufErfolgreich, dauer, parameter, ergebnis);
        }
    }

    protected void erstelleLogVorAuruf() {
        if (this.nachbarsystemAufruf) {
            this.helper.loggeNachbarsystemAufruf(this.logger, this.methode, this.nachbarsystemName, this.nachbarsystemUrl);
        } else {
            this.helper.loggeAufruf(this.logger, this.methode);
        }
    }

    protected void erstelleLogNachAufruf(boolean aufrufErfolgreich, long dauer, Object[] parameter, Object ergebnis) {
        if (this.nachbarsystemAufruf) {
            this.helper.loggeNachbarsystemErgebnis(this.logger, this.methode, this.nachbarsystemName, this.nachbarsystemUrl, aufrufErfolgreich);
            this.helper.loggeNachbarsystemDauer(this.logger, this.methode, dauer, this.nachbarsystemName, this.nachbarsystemUrl, aufrufErfolgreich);
        } else {
            this.helper.loggeDauer(this.logger, this.methode, dauer, aufrufErfolgreich);
            this.helper.loggeErgebnis(this.logger, this.methode, aufrufErfolgreich, parameter, ergebnis);
        }
    }
}

