/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyMarker;
import de.bund.bva.isyfact.logging.LogKategorie;
import de.bund.bva.isyfact.logging.impl.Ereignisschluessel;
import de.bund.bva.isyfact.logging.impl.IsyMarkerImpl;
import de.bund.bva.isyfact.logging.impl.MarkerSchluessel;
import de.bund.bva.isyfact.logging.util.BeanConverter;
import de.bund.bva.isyfact.logging.util.BeanGroessePruefer;
import de.bund.bva.isyfact.logging.util.BeanToMapConverter;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;

public class LogHelper {
    private final boolean loggeAufruf;
    private final boolean loggeErgebnis;
    private final boolean loggeDauer;
    private final boolean loggeDaten;
    private final boolean loggeDatenBeiException;
    private final long loggeMaximaleParameterGroesse;
    private BeanConverter konverter;
    private final BeanGroessePruefer pruefer;

    public LogHelper(boolean loggeAufruf, boolean loggeErgebnis, boolean loggeDauer, boolean loggeDaten, boolean loggeDatenBeiException, long loggeMaximaleParameterGroesse) {
        this(loggeAufruf, loggeErgebnis, loggeDauer, loggeDaten, loggeDatenBeiException, loggeMaximaleParameterGroesse, null);
    }

    public LogHelper(boolean loggeAufruf, boolean loggeErgebnis, boolean loggeDauer, boolean loggeDaten, boolean loggeDatenBeiException, long loggeMaximaleParameterGroesse, BeanConverter konverter) {
        this.loggeAufruf = loggeAufruf;
        this.loggeErgebnis = loggeErgebnis;
        this.loggeDauer = loggeDauer;
        this.loggeDaten = loggeDaten;
        this.loggeDatenBeiException = loggeDatenBeiException;
        this.loggeMaximaleParameterGroesse = loggeMaximaleParameterGroesse;
        this.pruefer = new BeanGroessePruefer();
        this.konverter = konverter == null ? LogHelper.erstelleStandardKonverter() : konverter;
    }

    public static BeanToMapConverter erstelleStandardKonverter() {
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("de.bund.bva");
        return new BeanToMapConverter(includes, null);
    }

    public void loggeAufruf(IsyLogger logger, Method methode) {
        if (this.loggeAufruf) {
            logger.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO01001.name(), Ereignisschluessel.EISYLO01001.getNachricht(), LogHelper.erstelleMethodenname(methode), LogHelper.erstelleSignatur(methode));
        }
    }

    public void loggeErgebnis(IsyLogger logger, Method methode, boolean erfolgreich, Object[] parameter, Object ergebnis) {
        boolean loggeAufrufUndErgebnisdaten;
        if (this.loggeErgebnis) {
            if (erfolgreich) {
                logger.info(LogKategorie.METRIK, Ereignisschluessel.EISYLO01002.name(), Ereignisschluessel.EISYLO01002.getNachricht(), LogHelper.erstelleMethodenname(methode), LogHelper.erstelleSignatur(methode));
            } else {
                logger.info(LogKategorie.METRIK, Ereignisschluessel.EISYLO01003.name(), Ereignisschluessel.EISYLO01003.getNachricht(), LogHelper.erstelleMethodenname(methode), LogHelper.erstelleSignatur(methode));
            }
        }
        boolean bl = loggeAufrufUndErgebnisdaten = this.loggeDaten || !erfolgreich && this.loggeDatenBeiException;
        if (loggeAufrufUndErgebnisdaten) {
            ArrayList<Object> parameterWerte = null;
            if (parameter != null) {
                parameterWerte = new ArrayList<Object>();
                for (int index = 0; index < parameter.length; ++index) {
                    if (this.pruefer.pruefeGroesse(parameter[index], this.loggeMaximaleParameterGroesse)) {
                        parameterWerte.add(this.konverter.convert(parameter[index]));
                        continue;
                    }
                    parameterWerte.add(Ereignisschluessel.DEBUG_LOGGE_DATEN_PARAMETER_ZU_GROSS.getNachricht());
                    logger.debugFachdaten(Ereignisschluessel.DEBUG_LOGGE_DATEN_GROESSE.getNachricht(), LogHelper.erstelleMethodenname(methode), index + 1, parameterWerte.getClass().getName());
                }
            }
            logger.debugFachdaten(Ereignisschluessel.DEBUG_LOGGE_DATEN.getNachricht(), LogHelper.erstelleMethodenname(methode), parameterWerte, ergebnis, LogHelper.erstelleSignatur(methode));
        }
    }

    public void loggeDauer(IsyLogger logger, Method methode, long dauer, boolean erfolgreich) {
        if (this.loggeDauer) {
            if (erfolgreich) {
                logger.info(LogKategorie.PROFILING, Ereignisschluessel.EISYLO01004.name(), Ereignisschluessel.EISYLO01004.getNachricht(), LogHelper.erstelleMethodenname(methode), new IsyMarkerImpl(MarkerSchluessel.DAUER, String.valueOf(dauer)), LogHelper.erstelleSignatur(methode));
            } else {
                logger.info(LogKategorie.PROFILING, Ereignisschluessel.EISYLO01005.name(), Ereignisschluessel.EISYLO01005.getNachricht(), LogHelper.erstelleMethodenname(methode), new IsyMarkerImpl(MarkerSchluessel.DAUER, String.valueOf(dauer)), LogHelper.erstelleSignatur(methode));
            }
        }
    }

    public void loggeNachbarsystemAufruf(IsyLogger logger, Method methode, String nachbarsystemName, String nachbarsystemUrl) {
        if (this.loggeAufruf) {
            logger.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO01011.name(), Ereignisschluessel.EISYLO01011.getNachricht(), LogHelper.erstelleMethodenname(methode), nachbarsystemName, nachbarsystemUrl, LogHelper.erstelleSignatur(methode));
        }
    }

    public void loggeNachbarsystemErgebnis(IsyLogger logger, Method methode, String nachbarsystemName, String nachbarsystemUrl, boolean erfolgreich) {
        if (this.loggeErgebnis) {
            if (erfolgreich) {
                logger.info(LogKategorie.METRIK, Ereignisschluessel.EISYLO01012.name(), Ereignisschluessel.EISYLO01012.getNachricht(), LogHelper.erstelleMethodenname(methode), nachbarsystemName, nachbarsystemUrl, LogHelper.erstelleSignatur(methode));
            } else {
                logger.info(LogKategorie.METRIK, Ereignisschluessel.EISYLO01013.name(), Ereignisschluessel.EISYLO01013.getNachricht(), LogHelper.erstelleMethodenname(methode), nachbarsystemName, nachbarsystemUrl, LogHelper.erstelleSignatur(methode));
            }
        }
    }

    public void loggeNachbarsystemDauer(IsyLogger logger, Method methode, long dauer, String nachbarsystemName, String nachbarsystemUrl, boolean erfolgreich) {
        if (this.loggeDauer) {
            if (erfolgreich) {
                logger.info(LogKategorie.PROFILING, Ereignisschluessel.EISYLO01014.name(), Ereignisschluessel.EISYLO01014.getNachricht(), LogHelper.erstelleMethodenname(methode), nachbarsystemName, nachbarsystemUrl, new IsyMarkerImpl(MarkerSchluessel.DAUER, String.valueOf(dauer)), LogHelper.erstelleSignatur(methode));
            } else {
                logger.info(LogKategorie.PROFILING, Ereignisschluessel.EISYLO01015.name(), Ereignisschluessel.EISYLO01015.getNachricht(), LogHelper.erstelleMethodenname(methode), nachbarsystemName, nachbarsystemUrl, new IsyMarkerImpl(MarkerSchluessel.DAUER, String.valueOf(dauer)), LogHelper.erstelleSignatur(methode));
            }
        }
    }

    public long ermittleAktuellenZeitpunkt() {
        return Instant.now().toEpochMilli();
    }

    private static IsyMarker erstelleSignatur(Method methode) {
        String signatur = methode.toString();
        int throwIndex = signatur.indexOf(" throws ");
        if (throwIndex >= 0) {
            signatur = signatur.substring(0, throwIndex);
        }
        return new IsyMarkerImpl(MarkerSchluessel.METHODE, signatur);
    }

    private static String erstelleMethodenname(Method methode) {
        return methode.getDeclaringClass().getSimpleName() + "." + methode.getName();
    }

    public void setKonverter(BeanToMapConverter konverter) {
        this.konverter = konverter;
    }

    public BeanConverter getKonverter() {
        return this.konverter;
    }
}

