/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import de.bund.bva.isyfact.logging.exceptions.SerialisierungException;
import de.bund.bva.isyfact.logging.util.BeanConverter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BeanToMapConverter
implements BeanConverter {
    private final List<String> includes;
    private final List<String> excludes;
    public static final String NULL_STRING = "null";
    public static final String HASHCODE_KEY = "hashCode";
    public static final String EXCLUDED_VALUE = "NICHT_SERIALISIERT";

    public BeanToMapConverter(List<String> includes, List<String> excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public Object convert(Object bean) {
        if (bean == null) {
            return NULL_STRING;
        }
        try {
            return this.processValue(bean, new HashSet<Object>());
        }
        catch (Exception e) {
            throw new SerialisierungException("ISYLO01001", e, new String[0]);
        }
    }

    private Map<String, Object> collectAttributesRecursive(Object bean, Set<Object> seen) {
        PropertyDescriptor[] propertyDescriptors;
        BeanInfo beanInfo;
        TreeMap<String, Object> propertyMap = new TreeMap<String, Object>();
        propertyMap.put(HASHCODE_KEY, "" + bean.hashCode());
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new SerialisierungException("ISYLO01001", e, new String[0]);
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            Object value;
            String name = propertyDescriptor.getName();
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null) continue;
            try {
                value = readMethod.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new SerialisierungException("ISYLO01001", e, new String[0]);
            }
            Object converted = value == null ? this.processValue(value, seen) : this.processValue(value, seen);
            if (converted == null) continue;
            propertyMap.put(name, converted);
        }
        return propertyMap;
    }

    private Object processSimpleValue(Object value, Set<Object> seen) {
        ConversionStyle serialisierungsart = this.determineConversionStyle(value);
        switch (serialisierungsart) {
            case TOSTRING: {
                return this.convertToString(value);
            }
            case RECURSIVE: {
                if (seen.contains(value)) {
                    return "Bereits verarbeitet: " + value.hashCode();
                }
                seen.add(value);
                return this.collectAttributesRecursive(value, seen);
            }
        }
        return EXCLUDED_VALUE;
    }

    private Object processValue(Object value, Set<Object> seen) {
        if (value == null) {
            return this.processSimpleValue(value, seen);
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object entry = Array.get(value, i);
                valueList.add(entry);
            }
            value = valueList;
        }
        if (value instanceof Iterable) {
            return this.processIterableValue((Iterable)value, seen);
        }
        if (value instanceof Map) {
            return this.processMapValue((Map)((Object)value), seen);
        }
        return this.processSimpleValue(value, seen);
    }

    private Object processMapValue(Map<?, ?> value, Set<Object> seen) {
        TreeMap<Object, Object> convertedMap = new TreeMap<Object, Object>(Comparator.comparing(Object::toString));
        for (Object mapKey : value.keySet()) {
            Object mapValue = value.get(mapKey);
            Object convertedKey = this.processValue(mapKey, seen);
            if (convertedKey == null) continue;
            Object convertedValue = this.processValue(mapValue, seen);
            convertedMap.put(convertedKey, convertedValue);
        }
        return convertedMap;
    }

    private List<Object> processIterableValue(Iterable<?> iterable, Set<Object> seen) {
        ArrayList<Object> convertedMap = new ArrayList<Object>();
        for (Object value : iterable) {
            Object converted = this.processValue(value, seen);
            if (converted == null) continue;
            convertedMap.add(converted);
        }
        return convertedMap;
    }

    private String convertToString(Object value) {
        if (value == null) {
            return NULL_STRING;
        }
        return value.toString();
    }

    protected ConversionStyle determineConversionStyle(Object value) {
        if (value == null) {
            return ConversionStyle.TOSTRING;
        }
        Class<?> classObj = value.getClass();
        String className = classObj.getName();
        if (classObj.isEnum()) {
            return ConversionStyle.TOSTRING;
        }
        boolean included = this.checkIsInclude(className);
        boolean excluded = this.checkIsExclude(className);
        if (excluded) {
            return ConversionStyle.IGNORE;
        }
        if (included) {
            return ConversionStyle.RECURSIVE;
        }
        return ConversionStyle.TOSTRING;
    }

    private boolean checkIsInclude(String className) {
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String include : this.includes) {
                if (!className.startsWith(include)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIsExclude(String className) {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            for (String exclude : this.excludes) {
                if (!className.startsWith(exclude)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    protected static enum ConversionStyle {
        RECURSIVE,
        TOSTRING,
        IGNORE;

    }
}

