/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.impl;

import de.bund.bva.isyfact.exception.BaseException;
import de.bund.bva.isyfact.exception.TechnicalRuntimeException;
import de.bund.bva.isyfact.logging.IsyDatentypMarker;
import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyMarker;
import de.bund.bva.isyfact.logging.LogKategorie;
import de.bund.bva.isyfact.logging.exceptions.FehlerhafterLogeintrag;
import de.bund.bva.isyfact.logging.impl.FachdatenMarker;
import de.bund.bva.isyfact.logging.impl.IsyMarkerImpl;
import de.bund.bva.isyfact.logging.impl.LogErrorKategorie;
import de.bund.bva.isyfact.logging.impl.MarkerSchluessel;
import de.bund.bva.isyfact.logging.impl.TechnikdatenMarker;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class IsyLocationAwareLoggerImpl
implements IsyLogger {
    private final String fqcn = IsyLocationAwareLoggerImpl.class.getName();
    private static final Throwable DEFAULT_THROWABLE = null;
    private static final IsyMarker[] FACHDATEN_MARKER = new IsyMarker[]{new FachdatenMarker()};
    private static final IsyMarker[] TECHNIKDATEN_MARKER = new IsyMarker[]{new TechnikdatenMarker()};
    private final LocationAwareLogger logger;

    public IsyLocationAwareLoggerImpl(LocationAwareLogger logger) {
        this.logger = logger;
    }

    @Override
    public void trace(String nachricht, Object ... werte) {
        this.log(0, null, TECHNIKDATEN_MARKER, null, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void traceFachdaten(String nachricht, Object ... werte) {
        this.log(0, null, FACHDATEN_MARKER, null, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void debug(String nachricht, Object ... werte) {
        this.log(10, null, TECHNIKDATEN_MARKER, null, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void debugFachdaten(String nachricht, Object ... werte) {
        this.log(10, null, FACHDATEN_MARKER, null, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void info(LogKategorie kategorie, String schluessel, String nachricht, Object ... werte) {
        this.log(20, kategorie.name(), TECHNIKDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void infoFachdaten(LogKategorie kategorie, String schluessel, String nachricht, Object ... werte) {
        this.log(20, kategorie.name(), FACHDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void info(LogKategorie kategorie, String nachricht, BaseException exception, Object ... werte) {
        this.logException(20, kategorie.name(), TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void infoFachdaten(LogKategorie kategorie, String nachricht, BaseException exception, Object ... werte) {
        this.logException(20, kategorie.name(), FACHDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void warn(String nachricht, BaseException exception, Object ... werte) {
        this.logException(30, null, TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void warnFachdaten(String nachricht, BaseException exception, Object ... werte) {
        this.logException(30, null, FACHDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void error(String nachricht, BaseException exception, Object ... werte) {
        this.logException(40, LogErrorKategorie.ERROR.name(), TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void errorFachdaten(String nachricht, BaseException exception, Object ... werte) {
        this.logException(40, LogErrorKategorie.ERROR.name(), FACHDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void fatal(String nachricht, BaseException exception, Object ... werte) {
        this.logException(40, LogErrorKategorie.FATAL.name(), TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void fatalFachdaten(String nachricht, BaseException exception, Object ... werte) {
        this.logException(40, LogErrorKategorie.FATAL.name(), FACHDATEN_MARKER, nachricht, werte, exception);
    }

    private void logException(int level, String kategorie, IsyMarker[] expliziteMarker, String nachricht, Object[] werte, BaseException exception) {
        this.log(level, kategorie, expliziteMarker, exception.getAusnahmeId(), nachricht, werte, (Throwable)exception);
    }

    private void logTechnicalRuntimeException(int level, String kategorie, IsyMarker[] expliziteMarker, String nachricht, Object[] werte, TechnicalRuntimeException exception) {
        this.log(level, kategorie, expliziteMarker, exception.getAusnahmeId(), nachricht, werte, (Throwable)exception);
    }

    private void log(int level, String kategorie, IsyMarker[] expliziteMarker, String schluessel, String nachricht, Object[] werte, Throwable t) {
        IsyMarker rootMarker = IsyMarkerImpl.createRootMarker();
        if (kategorie == null) {
            if (this.pruefeIstKategoriePflicht(level)) {
                throw new FehlerhafterLogeintrag("ISYLO00002", this.ermittleLevelString(level), this.logger.getName());
            }
        } else {
            rootMarker.add(new IsyMarkerImpl(MarkerSchluessel.KATEGORIE, kategorie));
        }
        if (t != null || schluessel != null) {
            rootMarker.add(new IsyMarkerImpl(MarkerSchluessel.SCHLUESSEL, schluessel));
        } else if (this.pruefeIstSchluesselPflicht(level)) {
            throw new FehlerhafterLogeintrag("ISYLO00001", this.ermittleLevelString(level), this.logger.getName());
        }
        if (expliziteMarker != null) {
            for (IsyMarker isyMarker : expliziteMarker) {
                rootMarker.add(isyMarker);
            }
        }
        for (int i = 0; i < werte.length; ++i) {
            if (!(werte[i] instanceof IsyMarker)) continue;
            IsyMarker marker = (IsyMarker)werte[i];
            rootMarker.add(marker);
            werte[i] = marker.getValue();
        }
        this.logger.log((Marker)rootMarker, this.fqcn, level, nachricht, werte, t);
    }

    private String ermittleLevelString(int level) {
        switch (level) {
            case 10: {
                return "DEBUG";
            }
            case 40: {
                return "ERROR";
            }
            case 20: {
                return "INFO";
            }
            case 0: {
                return "TRACE";
            }
            case 30: {
                return "WARN";
            }
        }
        return null;
    }

    private boolean pruefeIstKategoriePflicht(int level) {
        return level == 20 || level == 40;
    }

    private boolean pruefeIstSchluesselPflicht(int level) {
        return level >= 20;
    }

    @Override
    public void info(LogKategorie kategorie, String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(20, LogKategorie.JOURNAL.name(), TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void info(LogKategorie kategorie, String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(20, kategorie.name(), TECHNIKDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void infoFachdaten(LogKategorie kategorie, String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(20, kategorie.name(), FACHDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void infoFachdaten(LogKategorie kategorie, String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(20, kategorie.name(), FACHDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void warn(String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(30, null, TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void warnFachdaten(String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(30, null, FACHDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void error(String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(40, LogErrorKategorie.ERROR.name(), TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void errorFachdaten(String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(40, LogErrorKategorie.ERROR.name(), FACHDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void fatal(String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(40, LogErrorKategorie.FATAL.name(), TECHNIKDATEN_MARKER, nachricht, werte, exception);
    }

    @Override
    public void fatalFachdaten(String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(40, LogErrorKategorie.FATAL.name(), FACHDATEN_MARKER, nachricht, werte, exception);
    }

    public LocationAwareLogger getLogger() {
        return this.logger;
    }

    @Override
    public void warn(String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(30, null, TECHNIKDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void warnFachdaten(String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(30, null, FACHDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void error(String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(40, LogErrorKategorie.ERROR.name(), TECHNIKDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void errorFachdaten(String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(40, LogErrorKategorie.ERROR.name(), FACHDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void fatal(String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(40, LogErrorKategorie.FATAL.name(), TECHNIKDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void fatalFachdaten(String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(40, LogErrorKategorie.FATAL.name(), FACHDATEN_MARKER, schluessel, nachricht, werte, t);
    }

    @Override
    public void warn(String schluessel, String nachricht, Object ... werte) {
        this.log(30, null, TECHNIKDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void warnFachdaten(String schluessel, String nachricht, Object ... werte) {
        this.log(30, null, FACHDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void error(String schluessel, String nachricht, Object ... werte) {
        this.log(40, LogErrorKategorie.ERROR.name(), TECHNIKDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void errorFachdaten(String schluessel, String nachricht, Object ... werte) {
        this.log(40, LogErrorKategorie.ERROR.name(), FACHDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void fatal(String schluessel, String nachricht, Object ... werte) {
        this.log(40, LogErrorKategorie.FATAL.name(), TECHNIKDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void fatalFachdaten(String schluessel, String nachricht, Object ... werte) {
        this.log(40, LogErrorKategorie.FATAL.name(), FACHDATEN_MARKER, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void trace(IsyDatentypMarker typ, String nachricht, Object ... werte) {
        this.log(0, null, new IsyMarker[]{typ}, null, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void debug(IsyDatentypMarker typ, String nachricht, Object ... werte) {
        this.log(10, null, new IsyMarker[]{typ}, null, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void info(LogKategorie kategorie, IsyDatentypMarker typ, String schluessel, String nachricht, Object ... werte) {
        this.log(20, kategorie.name(), new IsyMarker[]{typ}, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void info(LogKategorie kategorie, IsyDatentypMarker typ, String nachricht, BaseException exception, Object ... werte) {
        this.logException(20, kategorie.name(), new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void info(LogKategorie kategorie, IsyDatentypMarker typ, String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(20, kategorie.name(), new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void info(LogKategorie kategorie, IsyDatentypMarker typ, String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(20, kategorie.name(), new IsyMarker[]{typ}, schluessel, nachricht, werte, t);
    }

    @Override
    public void warn(IsyDatentypMarker typ, String schluessel, String nachricht, Object ... werte) {
        this.log(30, null, new IsyMarker[]{typ}, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void warn(IsyDatentypMarker typ, String nachricht, BaseException exception, Object ... werte) {
        this.logException(30, null, new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void warn(IsyDatentypMarker typ, String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(30, null, new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void warn(IsyDatentypMarker typ, String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(30, null, new IsyMarker[]{typ}, schluessel, nachricht, werte, t);
    }

    @Override
    public void error(IsyDatentypMarker typ, String nachricht, BaseException exception, Object ... werte) {
        this.logException(40, LogErrorKategorie.ERROR.name(), new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void error(IsyDatentypMarker typ, String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(40, LogErrorKategorie.ERROR.name(), new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void error(IsyDatentypMarker typ, String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(40, LogErrorKategorie.ERROR.name(), new IsyMarker[]{typ}, schluessel, nachricht, werte, t);
    }

    @Override
    public void error(IsyDatentypMarker typ, String schluessel, String nachricht, Object ... werte) {
        this.log(40, LogErrorKategorie.ERROR.name(), new IsyMarker[]{typ}, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }

    @Override
    public void fatal(IsyDatentypMarker typ, String nachricht, BaseException exception, Object ... werte) {
        this.logException(40, LogErrorKategorie.FATAL.name(), new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void fatal(IsyDatentypMarker typ, String nachricht, TechnicalRuntimeException exception, Object ... werte) {
        this.logTechnicalRuntimeException(40, LogErrorKategorie.FATAL.name(), new IsyMarker[]{typ}, nachricht, werte, exception);
    }

    @Override
    public void fatal(IsyDatentypMarker typ, String schluessel, String nachricht, Throwable t, Object ... werte) {
        this.log(40, LogErrorKategorie.FATAL.name(), new IsyMarker[]{typ}, schluessel, nachricht, werte, t);
    }

    @Override
    public void fatal(IsyDatentypMarker typ, String schluessel, String nachricht, Object ... werte) {
        this.log(40, LogErrorKategorie.FATAL.name(), new IsyMarker[]{typ}, schluessel, nachricht, werte, DEFAULT_THROWABLE);
    }
}

