/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanGroessePruefer {
    private static final Map<Class<?>, Integer> PRIMITIVE_TYPEN_GROESSE;

    public boolean pruefeGroesse(Object bean, Long maximalSize) {
        return maximalSize == null || maximalSize <= 0L || this.ermittleGroesseInBytes(bean, maximalSize);
    }

    private boolean ermittleGroesseInBytes(Object bean, Long maximalGroesse) {
        Set bereitsGezaehlteBeans = Collections.newSetFromMap(new IdentityHashMap());
        long beanGroesse = 0L;
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        if (bean != null) {
            stack.push(bean);
        }
        while (!stack.isEmpty() && beanGroesse <= maximalGroesse) {
            Object objekt = stack.pop();
            if (objekt == null || Enum.class.isAssignableFrom(objekt.getClass()) || objekt instanceof Class || !bereitsGezaehlteBeans.add(objekt)) continue;
            Class<?> klasse = objekt.getClass();
            if (PRIMITIVE_TYPEN_GROESSE.containsKey(klasse)) {
                beanGroesse += (long)PRIMITIVE_TYPEN_GROESSE.get(klasse).intValue();
                continue;
            }
            if (klasse.isArray()) {
                if (PRIMITIVE_TYPEN_GROESSE.containsKey(klasse.getComponentType())) {
                    beanGroesse += (long)(PRIMITIVE_TYPEN_GROESSE.get(klasse.getComponentType()) * Array.getLength(objekt));
                    continue;
                }
                for (int i = Array.getLength(objekt) - 1; i >= 0; --i) {
                    Object childValue = Array.get(objekt, i);
                    if (childValue == null) continue;
                    stack.push(childValue);
                }
                continue;
            }
            for (Field attribut : this.ermittleAlleInstanzAttribute(objekt)) {
                try {
                    Object attributWert = attribut.get(objekt);
                    if (attributWert == null) continue;
                    if (PRIMITIVE_TYPEN_GROESSE.containsKey(attributWert.getClass())) {
                        beanGroesse += (long)PRIMITIVE_TYPEN_GROESSE.get(attributWert.getClass()).intValue();
                        continue;
                    }
                    stack.push(attributWert);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return beanGroesse <= maximalGroesse;
    }

    private List<Field> ermittleAlleInstanzAttribute(Object instanz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = instanz.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : Arrays.asList(clazz.getDeclaredFields())) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        try {
            AccessibleObject.setAccessible(fields.toArray(new AccessibleObject[fields.size()]), true);
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
        return fields;
    }

    static {
        HashMap<Class<Double>, Integer> typen = new HashMap<Class<Double>, Integer>();
        typen.put(Boolean.TYPE, 1);
        typen.put(Boolean.class, 1);
        typen.put(Byte.TYPE, 1);
        typen.put(Byte.class, 1);
        typen.put(Character.TYPE, 2);
        typen.put(Character.class, 2);
        typen.put(Short.TYPE, 2);
        typen.put(Short.class, 2);
        typen.put(Integer.TYPE, 4);
        typen.put(Integer.class, 4);
        typen.put(Float.TYPE, 4);
        typen.put(Float.class, 4);
        typen.put(Long.TYPE, 8);
        typen.put(Long.class, 8);
        typen.put(Double.TYPE, 8);
        typen.put(Double.class, 8);
        PRIMITIVE_TYPEN_GROESSE = Collections.unmodifiableMap(typen);
    }
}

