/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.impl;

import de.bund.bva.isyfact.logging.IsyMarker;
import de.bund.bva.isyfact.logging.impl.MarkerSchluessel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Marker;

public class IsyMarkerImpl
implements IsyMarker {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String value;
    private static final String ROOT_MARKER_VALUE = null;
    private final boolean root;
    private final List<Marker> references = new ArrayList<Marker>();

    public IsyMarkerImpl(MarkerSchluessel name, String value) {
        this(name.getWert(), value, false);
    }

    public static IsyMarker createRootMarker() {
        return new IsyMarkerImpl(MarkerSchluessel.ROOTMARKER.getWert(), ROOT_MARKER_VALUE, true);
    }

    IsyMarkerImpl(String name, String value, boolean root) {
        this.name = name;
        this.value = value;
        this.root = root;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public boolean remove(Marker reference) {
        return this.references.remove(reference);
    }

    public boolean hasChildren() {
        return this.hasReferences();
    }

    public boolean hasReferences() {
        return !this.references.isEmpty();
    }

    public Iterator<Marker> iterator() {
        return this.references.iterator();
    }

    public boolean contains(String markerName) {
        if (this.name.equals(markerName)) {
            return true;
        }
        for (Marker reference : this.references) {
            if (!reference.contains(markerName)) continue;
            return true;
        }
        return false;
    }

    public void add(Marker reference) {
        this.references.add(reference);
    }

    public boolean contains(Marker other) {
        return this.references.contains(other);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IsyMarker) {
            IsyMarker comp = (IsyMarker)obj;
            return this.compare(this.name, comp.getName()) && this.compare(this.value, comp.getValue());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (this.name + this.value).hashCode();
    }

    private boolean compare(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    @Override
    public boolean isRootMarker() {
        return this.root;
    }

    @Override
    public void addAll(Collection<Marker> markerReferences) {
        if (markerReferences != null) {
            for (Marker marker : markerReferences) {
                this.references.add(marker);
            }
        }
    }
}

