/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.autoconfigure;

import de.bund.bva.isyfact.logging.config.AbstractBoundaryLoggerProperties;
import de.bund.bva.isyfact.logging.config.IsyLoggingApplicationLoggerProperties;
import de.bund.bva.isyfact.logging.config.IsyLoggingBoundaryLoggerProperties;
import de.bund.bva.isyfact.logging.config.IsyLoggingComponentLoggerProperties;
import de.bund.bva.isyfact.logging.util.LogApplicationListener;
import de.bund.bva.isyfact.logging.util.LoggingMethodInterceptor;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@ConditionalOnProperty(name={"isy.logging.autoconfiguration.enabled"}, matchIfMissing=true)
@EnableAspectJAutoProxy
@EnableConfigurationProperties
public class IsyLoggingAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="isy.logging.anwendung")
    public IsyLoggingApplicationLoggerProperties isyLoggingApplicationLoggerProperties() {
        return new IsyLoggingApplicationLoggerProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="isy.logging.boundary")
    public IsyLoggingBoundaryLoggerProperties isyLoggingBoundaryLoggerProperties() {
        return new IsyLoggingBoundaryLoggerProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="isy.logging.component")
    public IsyLoggingComponentLoggerProperties isyLoggingComponentLoggerProperties() {
        return new IsyLoggingComponentLoggerProperties();
    }

    @Bean
    public LogApplicationListener statusLogger(IsyLoggingApplicationLoggerProperties properties) {
        return new LogApplicationListener(properties.getTyp(), properties.getName(), properties.getVersion());
    }

    @Bean
    public LoggingMethodInterceptor boundaryLogInterceptor(IsyLoggingBoundaryLoggerProperties properties) {
        return this.createLoggingMethodInterceptor(properties);
    }

    @Bean
    public LoggingMethodInterceptor componentLogInterceptor(IsyLoggingComponentLoggerProperties properties) {
        return this.createLoggingMethodInterceptor(properties);
    }

    private LoggingMethodInterceptor createLoggingMethodInterceptor(AbstractBoundaryLoggerProperties properties) {
        LoggingMethodInterceptor interceptor = properties.getConverterExcludes().isEmpty() && properties.getConverterIncludes().isEmpty() ? new LoggingMethodInterceptor() : new LoggingMethodInterceptor(properties.getConverterIncludes(), properties.getConverterExcludes());
        interceptor.setLoggeDauer(properties.isLoggeDauer());
        interceptor.setLoggeAufruf(properties.isLoggeAufruf());
        interceptor.setLoggeErgebnis(properties.isLoggeErgebnis());
        interceptor.setLoggeDaten(properties.isLoggeDaten());
        interceptor.setLoggeDatenBeiException(properties.isLoggeDatenBeiException());
        return interceptor;
    }

    @Bean
    public Advisor boundaryLogAdvisorByAnnotation(IsyLoggingBoundaryLoggerProperties properties, @Qualifier(value="boundaryLogInterceptor") LoggingMethodInterceptor boundaryLogInterceptor) {
        return this.setupAdvisor(properties, boundaryLogInterceptor);
    }

    @Bean
    public Advisor componentLogAdvisorByAnnotation(IsyLoggingComponentLoggerProperties properties, @Qualifier(value="componentLogInterceptor") LoggingMethodInterceptor componentLogInterceptor) {
        return this.setupAdvisor(properties, componentLogInterceptor);
    }

    private Advisor setupAdvisor(AbstractBoundaryLoggerProperties properties, MethodInterceptor interceptor) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(properties.getPointcut());
        DefaultPointcutAdvisor adv = new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)interceptor);
        adv.setOrder(1000);
        return adv;
    }
}

