/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.konfiguration.common.impl;

import de.bund.bva.isyfact.konfiguration.common.exception.KonfigurationDateiException;
import de.bund.bva.isyfact.konfiguration.common.impl.PropertyDatei;
import de.bund.bva.isyfact.konfiguration.common.impl.RessourcenHelper;
import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.LogKategorie;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Deprecated
public class ReloadablePropertyProvider {
    private String namensSchema;
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(ReloadablePropertyProvider.class);
    private List<PropertyDatei> propertyDateien;
    private Properties properties;
    private List<String> propertyOrdner;

    public ReloadablePropertyProvider(String[] propertyDateinamen) {
        this(propertyDateinamen, ".*[.]properties");
    }

    public ReloadablePropertyProvider(String[] propertyDateinamen, String namensSchema) {
        this.namensSchema = namensSchema;
        this.ladePropertyDateien(propertyDateinamen);
    }

    private void ladePropertyDateien(String[] propertyDateinamen) {
        this.propertyDateien = new ArrayList<PropertyDatei>();
        this.propertyOrdner = new ArrayList<String>();
        for (String dateiname : propertyDateinamen) {
            if (RessourcenHelper.istOrdner(dateiname)) {
                if (dateiname.endsWith("/")) {
                    for (String propertyInOrdner : RessourcenHelper.ladePropertiesAusOrdner(dateiname, this.namensSchema)) {
                        this.propertyDateien.add(new PropertyDatei(propertyInOrdner));
                    }
                    this.propertyOrdner.add(dateiname);
                    continue;
                }
                throw new KonfigurationDateiException("KONF203", dateiname);
            }
            this.propertyDateien.add(new PropertyDatei(dateiname));
        }
        this.properties = this.mergeProperties();
    }

    private Properties mergeProperties() {
        Properties gesamtProperties = new Properties();
        for (PropertyDatei propertyDatei : this.propertyDateien) {
            gesamtProperties.putAll((Map<?, ?>)propertyDatei.getProperties());
        }
        return gesamtProperties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public synchronized boolean checkAndUpdate() {
        boolean propertiesVeraendert;
        boolean neueVersionGeladen = false;
        boolean propertyEntfernt = this.entferneGeloeschtePropertyDateien();
        boolean propertyHinzugefuegt = this.ladeNeuePropertyDateienAusOrdnern();
        for (PropertyDatei propertyDatei : this.propertyDateien) {
            if (!propertyDatei.isNeueVersionVerfuegbar()) continue;
            LOG.info(LogKategorie.JOURNAL, "EPLKON00001", "Die Konfigurationsdatei {} wird neu geladen.", new Object[]{propertyDatei.getDateiname()});
            neueVersionGeladen = true;
            propertyDatei.neuLaden();
        }
        boolean bl = propertiesVeraendert = neueVersionGeladen || propertyEntfernt || propertyHinzugefuegt;
        if (propertiesVeraendert) {
            this.properties = this.mergeProperties();
        }
        return propertiesVeraendert;
    }

    private boolean ladeNeuePropertyDateienAusOrdnern() {
        boolean propertyHinzugefuegt = false;
        for (String ordnerPfad : this.propertyOrdner) {
            if (ordnerPfad.endsWith("/")) {
                for (String dateiname : RessourcenHelper.ladePropertiesAusOrdner(ordnerPfad, this.namensSchema)) {
                    boolean propertyIstNeu = true;
                    for (PropertyDatei existierendeProperty : this.propertyDateien) {
                        if (!dateiname.equals(existierendeProperty.getDateiname())) continue;
                        propertyIstNeu = false;
                        break;
                    }
                    if (!propertyIstNeu) continue;
                    propertyHinzugefuegt = true;
                    this.propertyDateien.add(new PropertyDatei(dateiname));
                }
                continue;
            }
            throw new KonfigurationDateiException("KONF203", ordnerPfad);
        }
        return propertyHinzugefuegt;
    }

    private boolean entferneGeloeschtePropertyDateien() {
        boolean propertyGeloescht = false;
        Iterator<PropertyDatei> it = this.propertyDateien.iterator();
        while (it.hasNext()) {
            PropertyDatei propertyDatei = it.next();
            for (String ordnerPfad : this.propertyOrdner) {
                if (!propertyDatei.getDateiname().startsWith(ordnerPfad) || propertyDatei.existiert()) continue;
                propertyGeloescht = true;
                it.remove();
            }
        }
        return propertyGeloescht;
    }
}

