/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.konfiguration.common.impl;

import de.bund.bva.isyfact.konfiguration.common.exception.KonfigurationDateiException;
import de.bund.bva.isyfact.konfiguration.common.impl.RessourcenHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class PropertyDatei {
    private String dateiname;
    private File propertyFile;
    private Properties properties;
    private long letzteAenderung;

    PropertyDatei(String dateiname) {
        this.dateiname = dateiname;
        try {
            this.propertyFile = new File(RessourcenHelper.getAbsoluterPfad(dateiname));
            this.letzteAenderung = this.propertyFile.lastModified();
            this.neuLaden();
        }
        catch (IllegalArgumentException ex) {
            throw new KonfigurationDateiException("KONF202", (Throwable)ex, dateiname);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isNeueVersionVerfuegbar() {
        return this.propertyFile.lastModified() != this.letzteAenderung;
    }

    public void neuLaden() {
        Properties neueProperties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(this.propertyFile);
            neueProperties.load(inputStream);
            this.letzteAenderung = this.propertyFile.lastModified();
            ((InputStream)inputStream).close();
            this.properties = neueProperties;
        }
        catch (FileNotFoundException ex) {
            throw new KonfigurationDateiException("KONF201", (Throwable)ex, this.dateiname);
        }
        catch (IOException ex) {
            throw new KonfigurationDateiException("KONF200", (Throwable)ex, this.dateiname);
        }
        catch (IllegalArgumentException ex) {
            throw new KonfigurationDateiException("KONF202", (Throwable)ex, this.dateiname);
        }
    }

    public String getDateiname() {
        return this.dateiname;
    }

    public boolean existiert() {
        return this.propertyFile.exists();
    }
}

