/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.konfiguration.common.impl;

import de.bund.bva.isyfact.konfiguration.common.Konfiguration;
import de.bund.bva.isyfact.konfiguration.common.exception.KonfigurationDateiException;
import de.bund.bva.isyfact.konfiguration.common.impl.AbstractKonfiguration;
import de.bund.bva.isyfact.konfiguration.common.impl.RessourcenHelper;
import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyKonfiguration
extends AbstractKonfiguration
implements Konfiguration {
    private String namensSchema;
    private Properties properties;
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(PropertyKonfiguration.class);

    public PropertyKonfiguration(Properties properties) {
        this(properties, ".*[.]properties");
    }

    public PropertyKonfiguration(Properties properties, String namensSchema) {
        this.namensSchema = namensSchema;
        this.properties = properties;
    }

    public PropertyKonfiguration(String propertyLocation) {
        this(propertyLocation, ".*[.]properties");
    }

    public PropertyKonfiguration(String propertyLocation, String namensSchema) {
        if (!propertyLocation.endsWith("/")) {
            throw new KonfigurationDateiException("KONF203", propertyLocation);
        }
        this.namensSchema = namensSchema;
        this.properties = this.ladeMergedProperties(propertyLocation);
    }

    public PropertyKonfiguration(List<String> propertyLocations) {
        this(propertyLocations, ".*[.]properties");
    }

    public PropertyKonfiguration(List<String> propertyLocations, String namensSchema) {
        this.namensSchema = namensSchema;
        this.properties = this.ladeMergedProperties(propertyLocations);
    }

    private Properties ladeMergedProperties(List<String> propertyLocations) {
        Properties gesamtProperties = new Properties();
        for (String propertyLocation : propertyLocations) {
            if (RessourcenHelper.istOrdner(propertyLocation)) {
                if (propertyLocation.endsWith("/")) {
                    List<String> propertyDateien = RessourcenHelper.ladePropertiesAusOrdner(propertyLocation, this.namensSchema);
                    for (String propertyDatei : propertyDateien) {
                        gesamtProperties.putAll((Map<?, ?>)this.ladeProperties(propertyDatei));
                    }
                    continue;
                }
                throw new KonfigurationDateiException("KONF203", propertyLocation);
            }
            gesamtProperties.putAll((Map<?, ?>)this.ladeProperties(propertyLocation));
        }
        return gesamtProperties;
    }

    private Properties ladeMergedProperties(String propertyLocation) {
        Properties gesamtProperties = new Properties();
        if (RessourcenHelper.istOrdner(propertyLocation)) {
            List<String> propertyDateien = RessourcenHelper.ladePropertiesAusOrdner(propertyLocation, this.namensSchema);
            for (String propertyDatei : propertyDateien) {
                gesamtProperties.putAll((Map<?, ?>)this.ladeProperties(propertyDatei));
            }
        }
        return gesamtProperties;
    }

    private Properties ladeProperties(String propertyLocation) {
        InputStream propertyStream = PropertyKonfiguration.class.getResourceAsStream(propertyLocation);
        if (propertyStream == null) {
            throw new KonfigurationDateiException("KONF201", propertyLocation);
        }
        Properties loadedProperties = new Properties();
        try {
            loadedProperties.load(propertyStream);
        }
        catch (IOException e) {
            throw new KonfigurationDateiException("KONF200", propertyLocation);
        }
        return loadedProperties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Set<String> getSchluessel() {
        return this.properties.keySet();
    }

    @Override
    protected boolean containsKey(String schluessel) {
        return this.properties.containsKey(schluessel);
    }

    @Override
    protected String getValue(String schluessel) {
        return this.properties.getProperty(schluessel);
    }
}

