/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.konfiguration.common.impl;

import de.bund.bva.isyfact.konfiguration.common.exception.KonfigurationDateiException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

class RessourcenHelper {
    public static final String DEFAULTNAMENSSCHEMA = ".*[.]properties";

    RessourcenHelper() {
    }

    public static List<String> ladePropertiesAusOrdner(String ordnerPfad, String namensSchema) {
        ArrayList<String> allePropertiesPfade = new ArrayList<String>();
        URI ordnerUri = RessourcenHelper.getAbsoluterPfad(ordnerPfad);
        File ordner = new File(ordnerUri);
        File[] alleProperties = ordner.listFiles();
        Arrays.sort(alleProperties, new FileComparator());
        for (File property : alleProperties) {
            if (!Pattern.matches(namensSchema, property.getName())) continue;
            String relativerPfad = ordnerPfad.concat(property.getName());
            allePropertiesPfade.add(relativerPfad);
        }
        return allePropertiesPfade;
    }

    public static URI getAbsoluterPfad(String relativerPfad) {
        URI absoluterPfad;
        URL url = RessourcenHelper.class.getResource(relativerPfad);
        if (url == null) {
            throw new KonfigurationDateiException("KONF201", relativerPfad);
        }
        try {
            absoluterPfad = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new KonfigurationDateiException("KONF200", (Throwable)ex, relativerPfad);
        }
        return absoluterPfad;
    }

    public static boolean istOrdner(String relativerPfad) {
        URI absoluterPfad = RessourcenHelper.getAbsoluterPfad(relativerPfad);
        return Files.isDirectory(Paths.get(absoluterPfad), new LinkOption[0]);
    }

    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

