/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.konfiguration.common.impl;

import de.bund.bva.isyfact.konfiguration.common.Konfiguration;
import de.bund.bva.isyfact.konfiguration.common.exception.KonfigurationParameterException;

public abstract class AbstractKonfiguration
implements Konfiguration {
    protected abstract boolean containsKey(String var1);

    protected abstract String getValue(String var1);

    @Override
    public String getAsRawString(String schluessel, String defaultWert) {
        if (!this.containsKey(schluessel)) {
            return defaultWert;
        }
        return this.getAsRawString(schluessel);
    }

    @Override
    public String getAsRawString(String schluessel) {
        if (!this.containsKey(schluessel)) {
            throw new KonfigurationParameterException("KONF100", schluessel);
        }
        return this.getValue(schluessel);
    }

    @Override
    public String getAsString(String schluessel, String defaultWert) {
        if (!this.containsKey(schluessel)) {
            return defaultWert;
        }
        return this.getAsString(schluessel).trim();
    }

    @Override
    public String getAsString(String schluessel) {
        if (!this.containsKey(schluessel)) {
            throw new KonfigurationParameterException("KONF100", schluessel);
        }
        return this.getValue(schluessel).trim();
    }

    @Override
    public int getAsInteger(String schluessel, int defaultWert) {
        if (!this.containsKey(schluessel)) {
            return defaultWert;
        }
        return this.getAsInteger(schluessel);
    }

    @Override
    public int getAsInteger(String schluessel) {
        if (!this.containsKey(schluessel)) {
            throw new KonfigurationParameterException("KONF100", schluessel);
        }
        String propValue = this.getValue(schluessel).trim();
        try {
            return Integer.parseInt(propValue);
        }
        catch (NumberFormatException ex) {
            throw new KonfigurationParameterException("KONF101", schluessel, propValue);
        }
    }

    @Override
    public double getAsDouble(String schluessel, double defaultWert) {
        if (!this.containsKey(schluessel)) {
            return defaultWert;
        }
        return this.getAsDouble(schluessel);
    }

    @Override
    public double getAsDouble(String schluessel) {
        if (!this.containsKey(schluessel)) {
            throw new KonfigurationParameterException("KONF100", schluessel);
        }
        String propValue = this.getValue(schluessel).trim();
        try {
            return Double.parseDouble(propValue);
        }
        catch (NumberFormatException ex) {
            throw new KonfigurationParameterException("KONF101", schluessel, propValue);
        }
    }

    @Override
    public long getAsLong(String schluessel, long defaultWert) {
        if (!this.containsKey(schluessel)) {
            return defaultWert;
        }
        return this.getAsLong(schluessel);
    }

    @Override
    public long getAsLong(String schluessel) {
        if (!this.containsKey(schluessel)) {
            throw new KonfigurationParameterException("KONF100", schluessel);
        }
        String propValue = this.getValue(schluessel).trim();
        try {
            return Long.parseLong(propValue);
        }
        catch (NumberFormatException ex) {
            throw new KonfigurationParameterException("KONF101", schluessel, propValue);
        }
    }

    @Override
    public boolean getAsBoolean(String schluessel, boolean defaultWert) {
        if (!this.containsKey(schluessel)) {
            return defaultWert;
        }
        return this.getAsBoolean(schluessel);
    }

    @Override
    public boolean getAsBoolean(String schluessel) {
        if (!this.containsKey(schluessel)) {
            throw new KonfigurationParameterException("KONF100", schluessel);
        }
        String propValue = this.getValue(schluessel).trim();
        if (propValue.equalsIgnoreCase("true")) {
            return true;
        }
        if (propValue.equalsIgnoreCase("false")) {
            return false;
        }
        throw new KonfigurationParameterException("KONF101", schluessel, propValue);
    }
}

