/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.pliscommon.konfiguration.common.impl;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.LogKategorie;
import de.bund.bva.isyfact.logging.util.MdcHelper;
import de.bund.bva.pliscommon.konfiguration.common.KonfigurationChangeListener;
import de.bund.bva.pliscommon.konfiguration.common.ReloadableKonfiguration;
import de.bund.bva.pliscommon.konfiguration.common.impl.PropertyKonfiguration;
import de.bund.bva.pliscommon.konfiguration.common.impl.ReloadablePropertyProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class ReloadablePropertyKonfiguration
implements ReloadableKonfiguration {
    private String namensSchema;
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(ReloadablePropertyKonfiguration.class);
    private ReloadablePropertyProvider propertyProvider;
    private PropertyKonfiguration propertyKonfiguration;
    private List<KonfigurationChangeListener> konfigurationChangeListener;

    public ReloadablePropertyKonfiguration(String[] propertyLocations) {
        this(propertyLocations, ".*[.]properties");
    }

    public ReloadablePropertyKonfiguration(String[] propertyLocations, String namensSchema) {
        this.namensSchema = namensSchema;
        this.propertyProvider = new ReloadablePropertyProvider(propertyLocations, namensSchema);
        this.konfigurationChangeListener = new LinkedList<KonfigurationChangeListener>();
        this.propertyKonfiguration = new PropertyKonfiguration(this.propertyProvider.getProperties(), namensSchema);
    }

    @Override
    public synchronized boolean checkAndUpdate() {
        boolean neueVersionGeladen;
        LOG.info(LogKategorie.JOURNAL, "EPLKON00002", "Pr\u00fcfe auf ge\u00e4nderte Konfigurationsdateien.", new Object[0]);
        boolean korrelationsIdGesetzt = false;
        if (MdcHelper.liesKorrelationsId() == null) {
            MdcHelper.pushKorrelationsId((String)UUID.randomUUID().toString());
            korrelationsIdGesetzt = true;
        }
        if (neueVersionGeladen = this.propertyProvider.checkAndUpdate()) {
            LOG.info(LogKategorie.JOURNAL, "EPLKON00002", "Mindestens eine Konfigurationsdatei wurde ge\u00e4ndert.", new Object[0]);
            Properties neueProperties = this.propertyProvider.getProperties();
            Properties aktuelleProperties = this.propertyKonfiguration.getProperties();
            this.propertyKonfiguration = new PropertyKonfiguration(neueProperties, this.namensSchema);
            this.fireKonfigurationChanged(aktuelleProperties, neueProperties);
        }
        if (korrelationsIdGesetzt) {
            MdcHelper.entferneKorrelationsId();
        }
        return neueVersionGeladen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireKonfigurationChanged(Properties bisherigeProperties, Properties neueProperties) {
        Set<String> geaenderteSchluessel = this.ermittleGeaenderteSchluessel(bisherigeProperties, neueProperties);
        for (String schluessel : geaenderteSchluessel) {
            LOG.debug("Konfigurationsparameter {} wurde ge\u00e4ndert.", new Object[]{schluessel});
        }
        if (geaenderteSchluessel.size() > 0) {
            ArrayList<KonfigurationChangeListener> notifyChangeListeners = new ArrayList<KonfigurationChangeListener>(this.konfigurationChangeListener.size());
            List<KonfigurationChangeListener> list = this.konfigurationChangeListener;
            synchronized (list) {
                if (this.konfigurationChangeListener.size() > 0) {
                    notifyChangeListeners.addAll(this.konfigurationChangeListener);
                    for (KonfigurationChangeListener listener : notifyChangeListeners) {
                        LOG.debug("Informiere {} \u00fcber Konfigurations\u00e4nderung.", new Object[]{listener.getClass().toString()});
                        listener.onKonfigurationChanged(Collections.unmodifiableSet(geaenderteSchluessel));
                    }
                }
            }
        }
    }

    private Set<String> ermittleGeaenderteSchluessel(Properties a, Properties b) {
        HashSet<String> geaenderteSchluessel = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : a.entrySet()) {
            if (b.containsKey(entry.getKey()) && b.get(entry.getKey()).equals(entry.getValue())) continue;
            geaenderteSchluessel.add((String)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : b.entrySet()) {
            if (a.containsKey(entry.getKey()) && a.get(entry.getKey()).equals(entry.getValue())) continue;
            geaenderteSchluessel.add((String)entry.getKey());
        }
        return geaenderteSchluessel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKonfigurationChangeListener(KonfigurationChangeListener listener) {
        if (listener != null) {
            List<KonfigurationChangeListener> list = this.konfigurationChangeListener;
            synchronized (list) {
                if (!this.konfigurationChangeListener.contains(listener)) {
                    this.konfigurationChangeListener.add(listener);
                } else {
                    LOG.info(LogKategorie.JOURNAL, "EPLKON00003", "Listener wurde nicht hinzugef\u00fcgt, da die gleiche Instanz bereits registriert ist.", new Object[0]);
                }
            }
        } else {
            LOG.debug("Listener ist null und wurde nicht hinzugef\u00fcgt.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKonfigurationChangeListener(KonfigurationChangeListener listener) {
        List<KonfigurationChangeListener> list = this.konfigurationChangeListener;
        synchronized (list) {
            this.konfigurationChangeListener.remove(listener);
        }
    }

    @Override
    public boolean getAsBoolean(String schluessel, boolean defaultWert) {
        return this.propertyKonfiguration.getAsBoolean(schluessel, defaultWert);
    }

    @Override
    public boolean getAsBoolean(String schluessel) {
        return this.propertyKonfiguration.getAsBoolean(schluessel);
    }

    @Override
    public double getAsDouble(String schluessel, double defaultWert) {
        return this.propertyKonfiguration.getAsDouble(schluessel, defaultWert);
    }

    @Override
    public double getAsDouble(String schluessel) {
        return this.propertyKonfiguration.getAsDouble(schluessel);
    }

    @Override
    public int getAsInteger(String schluessel, int defaultWert) {
        return this.propertyKonfiguration.getAsInteger(schluessel, defaultWert);
    }

    @Override
    public int getAsInteger(String schluessel) {
        return this.propertyKonfiguration.getAsInteger(schluessel);
    }

    @Override
    public long getAsLong(String schluessel, long defaultWert) {
        return this.propertyKonfiguration.getAsLong(schluessel, defaultWert);
    }

    @Override
    public long getAsLong(String schluessel) {
        return this.propertyKonfiguration.getAsLong(schluessel);
    }

    @Override
    public String getAsString(String schluessel, String defaultWert) {
        return this.propertyKonfiguration.getAsString(schluessel, defaultWert);
    }

    @Override
    public String getAsString(String schluessel) {
        return this.propertyKonfiguration.getAsString(schluessel);
    }

    @Override
    public String getAsRawString(String schluessel, String defaultWert) {
        return this.propertyKonfiguration.getAsRawString(schluessel, defaultWert);
    }

    @Override
    public String getAsRawString(String schluessel) {
        return this.propertyKonfiguration.getAsRawString(schluessel);
    }

    @Override
    public Set<String> getSchluessel() {
        return this.propertyKonfiguration.getSchluessel();
    }

    @Override
    public boolean hasKonfigurationChangeListener(KonfigurationChangeListener listener) {
        if (listener != null) {
            return this.konfigurationChangeListener.contains(listener);
        }
        return false;
    }
}

