/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.datetime.core;

import de.bund.bva.isyfact.datetime.format.InFormat;
import de.bund.bva.isyfact.datetime.format.OutFormat;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;

public class Zeitraum
implements Serializable {
    private static final long serialVersionUID = -1694209697511614665L;
    private ZonedDateTime anfang;
    private ZonedDateTime ende;
    private boolean ohneDatum = false;

    private Zeitraum(ZonedDateTime anfang, ZonedDateTime ende) {
        this.anfang = anfang;
        this.ende = ende;
    }

    private static ZonedDateTime getLocalDateTimeInJvmTimeZone(LocalDateTime localDateTime) {
        return ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
    }

    public static Zeitraum of(ZonedDateTime anfang, ZonedDateTime ende) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(ende);
        if (ende.isBefore(anfang)) {
            throw new DateTimeException("Der Anfang " + anfang + " liegt nach dem Ende " + ende + " des Zeitraums.");
        }
        return new Zeitraum(anfang, ende);
    }

    public static Zeitraum of(ZonedDateTime anfang, Duration dauer) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(dauer);
        if (dauer.isNegative()) {
            throw new DateTimeException("Die Dauer " + dauer + " darf nicht negativ sein.");
        }
        return new Zeitraum(anfang, anfang.plus(dauer));
    }

    public static Zeitraum of(ZonedDateTime anfang, Period dauer) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(dauer);
        if (dauer.isNegative()) {
            throw new DateTimeException("Die Dauer " + dauer + " darf nicht negativ sein.");
        }
        return new Zeitraum(anfang, anfang.plus(dauer));
    }

    public static Zeitraum of(LocalDateTime anfang, LocalDateTime ende) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(ende);
        if (ende.isBefore(anfang)) {
            throw new DateTimeException("Der Anfang " + anfang + " liegt nach dem Ende " + ende + " des Zeitraums.");
        }
        return new Zeitraum(Zeitraum.getLocalDateTimeInJvmTimeZone(anfang), Zeitraum.getLocalDateTimeInJvmTimeZone(ende));
    }

    public static Zeitraum of(LocalDateTime anfang, Duration dauer) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(dauer);
        if (dauer.isNegative()) {
            throw new DateTimeException("Die Dauer " + dauer + " darf nicht negativ sein.");
        }
        ZonedDateTime zonedAnfang = Zeitraum.getLocalDateTimeInJvmTimeZone(anfang);
        return new Zeitraum(zonedAnfang, zonedAnfang.plus(dauer));
    }

    public static Zeitraum of(LocalDateTime anfang, Period dauer) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(dauer);
        if (dauer.isNegative()) {
            throw new DateTimeException("Die Dauer " + dauer + " darf nicht negativ sein.");
        }
        ZonedDateTime zonedAnfang = Zeitraum.getLocalDateTimeInJvmTimeZone(anfang);
        return new Zeitraum(zonedAnfang, zonedAnfang.plus(dauer));
    }

    public static Zeitraum of(LocalDate anfang, LocalDate ende) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(ende);
        if (ende.isBefore(anfang)) {
            throw new DateTimeException("Der Anfang " + anfang + " liegt nach dem Ende " + ende + " des Zeitraums.");
        }
        ZonedDateTime zonedAnfang = Zeitraum.getLocalDateTimeInJvmTimeZone(LocalDateTime.of(anfang, LocalTime.MIDNIGHT));
        ZonedDateTime zonedEnde = Zeitraum.getLocalDateTimeInJvmTimeZone(LocalDateTime.of(ende, LocalTime.MIDNIGHT));
        return new Zeitraum(zonedAnfang, zonedEnde);
    }

    public static Zeitraum of(LocalDate anfang, Period dauer) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(dauer);
        if (dauer.isNegative()) {
            throw new DateTimeException("Die Dauer " + dauer + " darf nicht negativ sein.");
        }
        ZonedDateTime zonedAnfang = Zeitraum.getLocalDateTimeInJvmTimeZone(LocalDateTime.of(anfang, LocalTime.MIDNIGHT));
        return new Zeitraum(zonedAnfang, zonedAnfang.plus(dauer));
    }

    public static Zeitraum of(LocalTime anfang, LocalTime ende) {
        Zeitraum zeitraum;
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(ende);
        if (anfang.isBefore(ende) || anfang.equals(ende)) {
            ZonedDateTime anfangDate = ZonedDateTime.of(LocalDate.now(Clock.systemUTC()), anfang, ZoneOffset.UTC);
            ZonedDateTime endeDate = ZonedDateTime.of(LocalDate.now(Clock.systemUTC()), ende, ZoneOffset.UTC);
            zeitraum = new Zeitraum(anfangDate, endeDate);
            zeitraum.ohneDatum = true;
        } else {
            ZonedDateTime anfangDate = ZonedDateTime.of(LocalDate.now(Clock.systemUTC()), anfang, ZoneOffset.UTC);
            ZonedDateTime endeDate = ZonedDateTime.of(LocalDate.now(Clock.systemUTC()).plusDays(1L), ende, ZoneOffset.UTC);
            zeitraum = new Zeitraum(anfangDate, endeDate);
            zeitraum.ohneDatum = true;
        }
        return zeitraum;
    }

    public static Zeitraum of(LocalTime anfang, Duration dauer) {
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(dauer);
        if (dauer.isNegative()) {
            throw new DateTimeException("Die Dauer " + dauer + " darf nicht negativ sein.");
        }
        if (dauer.compareTo(Duration.ofDays(1L)) > 0) {
            throw new DateTimeException("Die Dauer " + dauer + " darf nicht l\u00e4nger als ein Tag sein.");
        }
        ZonedDateTime anfangDate = ZonedDateTime.of(LocalDate.now(Clock.systemUTC()), anfang, ZoneOffset.UTC);
        ZonedDateTime endeDate = anfangDate.plus(dauer);
        Zeitraum zeitraum = new Zeitraum(anfangDate, endeDate);
        zeitraum.ohneDatum = true;
        return zeitraum;
    }

    public static Zeitraum parse(String text) {
        Objects.requireNonNull(text);
        String[] anfangUndEndeOderDauer = Zeitraum.getZeitraumAnfangUndEndeOderDauerString(text);
        Object anfang = Zeitraum.parseAnfang(anfangUndEndeOderDauer[0]);
        Object endeOderDauer = Zeitraum.parseEnde(anfangUndEndeOderDauer[1]);
        if (anfang instanceof ZonedDateTime) {
            ZonedDateTime anfangZonedDateTime = (ZonedDateTime)anfang;
            if (endeOderDauer instanceof ZonedDateTime) {
                return Zeitraum.of(anfangZonedDateTime, (ZonedDateTime)endeOderDauer);
            }
            if (endeOderDauer instanceof Duration) {
                return Zeitraum.of(anfangZonedDateTime, (Duration)endeOderDauer);
            }
            if (endeOderDauer instanceof Period) {
                return Zeitraum.of(anfangZonedDateTime, (Period)endeOderDauer);
            }
        } else if (anfang instanceof LocalDateTime) {
            LocalDateTime anfangLocalDateTime = (LocalDateTime)anfang;
            if (endeOderDauer instanceof LocalDateTime) {
                return Zeitraum.of(anfangLocalDateTime, (LocalDateTime)endeOderDauer);
            }
            if (endeOderDauer instanceof Duration) {
                return Zeitraum.of(anfangLocalDateTime, (Duration)endeOderDauer);
            }
            if (endeOderDauer instanceof Period) {
                return Zeitraum.of(anfangLocalDateTime, (Period)endeOderDauer);
            }
        } else if (anfang instanceof LocalDate) {
            LocalDate anfangLocalDate = (LocalDate)anfang;
            if (endeOderDauer instanceof LocalDate) {
                return Zeitraum.of(anfangLocalDate, (LocalDate)endeOderDauer);
            }
            if (endeOderDauer instanceof Period) {
                return Zeitraum.of(anfangLocalDate, (Period)endeOderDauer);
            }
        } else if (anfang instanceof LocalTime) {
            LocalTime anfangLocalTime = (LocalTime)anfang;
            if (endeOderDauer instanceof LocalTime) {
                return Zeitraum.of(anfangLocalTime, (LocalTime)endeOderDauer);
            }
            if (endeOderDauer instanceof Duration) {
                return Zeitraum.of(anfangLocalTime, (Duration)endeOderDauer);
            }
        }
        throw new DateTimeParseException("Beim Parsen des Strings ist ein Fehler aufgetreten.", text, 0);
    }

    private static Object parseAnfang(String textAnfang) {
        ArrayList anfang = new ArrayList();
        anfang.add(Zeitraum.tryParse(InFormat::parseToZonedDateTime, textAnfang));
        anfang.add(Zeitraum.tryParse(InFormat::parseToOffsetDateTime, textAnfang));
        anfang.add(Zeitraum.tryParse(InFormat::parseToLocalDateTime, textAnfang));
        anfang.add(Zeitraum.tryParse(InFormat::parseToLocalDate, textAnfang));
        anfang.add(Zeitraum.tryParse(InFormat::parseToOffsetTime, textAnfang));
        anfang.add(Zeitraum.tryParse(InFormat::parseToLocalTime, textAnfang));
        return anfang.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new DateTimeParseException("Der Anfang des Zeitraums konnte nicht ermittelt werden.", textAnfang, 0));
    }

    private static Object parseEnde(String textEndeOderDauer) {
        ArrayList<Object> endeOderDauer = new ArrayList<Object>();
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToZonedDateTime, textEndeOderDauer));
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToOffsetDateTime, textEndeOderDauer));
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToLocalDateTime, textEndeOderDauer));
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToLocalDate, textEndeOderDauer));
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToOffsetTime, textEndeOderDauer));
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToLocalTime, textEndeOderDauer));
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToDuration, textEndeOderDauer));
        endeOderDauer.add(Zeitraum.tryParse(InFormat::parseToPeriod, textEndeOderDauer));
        return endeOderDauer.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new DateTimeParseException("Das Ende oder die Dauer des Zeitraums konnte nicht ermittelt werden.", textEndeOderDauer, 0));
    }

    private static <T> T tryParse(Function<String, T> parseFunction, String text) {
        try {
            return parseFunction.apply(text);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    private static String[] getZeitraumAnfangUndEndeOderDauerString(String text) {
        if (text.isEmpty()) {
            throw new DateTimeParseException("Der String war leer.", text, 0);
        }
        String[] teile = new String[2];
        try {
            teile[0] = text.split(", ")[0].trim();
            teile[1] = text.split(", ")[1].trim();
        }
        catch (Exception e) {
            throw new DateTimeParseException("Der String entspricht nicht dem Format \"<Anfang>, <Ende> | <Dauer>\"", text, 0);
        }
        return teile;
    }

    public long dauer(TemporalUnit unit) {
        Objects.requireNonNull(unit);
        return this.anfang.until(this.ende, unit);
    }

    public boolean isInZeitraum(ZonedDateTime dateTime) {
        if (this.ohneDatum) {
            return false;
        }
        return (dateTime.isAfter(this.anfang) || dateTime.isEqual(this.anfang)) && dateTime.isBefore(this.ende);
    }

    public boolean isInZeitraum(LocalDateTime dateTime) {
        if (this.ohneDatum) {
            return false;
        }
        ZonedDateTime zonedDateTime = Zeitraum.getLocalDateTimeInJvmTimeZone(dateTime);
        return this.isInZeitraum(zonedDateTime);
    }

    public boolean isInZeitraum(LocalDate date) {
        if (this.ohneDatum) {
            return false;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.of(date, LocalTime.of(0, 0), ZoneId.systemDefault());
        return this.isInZeitraum(zonedDateTime);
    }

    public boolean isInZeitraum(LocalTime localTime) {
        if (this.ohneDatum) {
            ZonedDateTime localTimeMitDatum = ZonedDateTime.of(this.anfang.toLocalDate(), localTime, ZoneId.of("UTC"));
            return (localTimeMitDatum.isAfter(this.anfang) || localTimeMitDatum.isEqual(this.anfang)) && localTimeMitDatum.isBefore(this.ende);
        }
        return this.isInZeitraum(ZonedDateTime.of(this.anfang.toLocalDate(), localTime, ZoneId.systemDefault()));
    }

    public boolean ueberschneidetSichMit(Zeitraum zeitraum) {
        if (zeitraum != null && this.ohneDatum == zeitraum.ohneDatum) {
            return this.teilweiseUeberschneidung(this, zeitraum) || this.teilweiseUeberschneidung(zeitraum, this) || this.kompletteUeberschneidung(this, zeitraum) || this.kompletteUeberschneidung(zeitraum, this) || this.equals(zeitraum);
        }
        return false;
    }

    private boolean teilweiseUeberschneidung(Zeitraum z1, Zeitraum z2) {
        return !(!z2.anfang.isBefore(z1.anfang) && !z2.anfang.isEqual(z1.anfang) || !z1.anfang.isBefore(z2.ende) && !z1.ende.isEqual(z2.ende));
    }

    private boolean kompletteUeberschneidung(Zeitraum z1, Zeitraum z2) {
        return z1.anfang.isBefore(z2.anfang) && z1.ende.isAfter(z2.ende);
    }

    public boolean isOhneDatum() {
        return this.ohneDatum;
    }

    public ZonedDateTime getAnfangsdatumzeit() {
        return this.ohneDatum ? null : this.anfang;
    }

    public ZonedDateTime getEndedatumzeit() {
        return this.ohneDatum ? null : this.ende;
    }

    public LocalTime getAnfangszeit() {
        return this.anfang.toLocalTime();
    }

    public LocalTime getEndzeit() {
        return this.ende.toLocalTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Zeitraum)) {
            return false;
        }
        Zeitraum zeitraum = (Zeitraum)o;
        return Objects.equals(this.anfang, zeitraum.anfang) && Objects.equals(this.ende, zeitraum.ende);
    }

    public int hashCode() {
        return Objects.hash(this.anfang, this.ende);
    }

    public String toString() {
        if (this.ohneDatum) {
            if (this.getAnfangszeit().getSecond() == 0 && this.getEndzeit().getSecond() == 0) {
                return OutFormat.ZEIT_KURZ.format(this.getAnfangszeit()) + " - " + OutFormat.ZEIT_KURZ.format(this.getEndzeit());
            }
            return OutFormat.ZEIT.format(this.getAnfangszeit()) + " - " + OutFormat.ZEIT.format(this.getEndzeit());
        }
        return OutFormat.DATUM_ZEIT_ZONE.format(this.anfang) + " - " + OutFormat.DATUM_ZEIT_ZONE.format(this.ende);
    }
}

