/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.datetime.core;

import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.Optional;

public class UngewisseZeit {
    private static final DateTimeFormatter format = new DateTimeFormatterBuilder().appendPattern("['xx:xx:xx']").appendPattern("[HH:'xx:xx']").appendPattern("[HH:mm:'xx']").appendPattern("[HH:mm:ss]").parseStrict().toFormatter();
    private static final int MIN_SEKUNDE = (int)ChronoField.SECOND_OF_MINUTE.range().getMinimum();
    private static final int MAX_SEKUNDE = (int)ChronoField.SECOND_OF_MINUTE.range().getMaximum();
    private static final int MIN_MINUTE = (int)ChronoField.MINUTE_OF_HOUR.range().getMinimum();
    private static final int MAX_MINUTE = (int)ChronoField.MINUTE_OF_HOUR.range().getMaximum();
    private LocalTime anfang;
    private LocalTime ende;

    private UngewisseZeit() {
    }

    private UngewisseZeit(LocalTime anfang, LocalTime ende) {
        this.anfang = anfang;
        this.ende = ende;
    }

    public static UngewisseZeit leer() {
        return new UngewisseZeit();
    }

    public static UngewisseZeit of(int stunde) {
        return new UngewisseZeit(LocalTime.of(stunde, MIN_MINUTE, MIN_SEKUNDE), LocalTime.of(stunde, MAX_MINUTE, MAX_SEKUNDE));
    }

    public static UngewisseZeit of(int stunde, int minute) {
        return new UngewisseZeit(LocalTime.of(stunde, minute, MIN_SEKUNDE), LocalTime.of(stunde, minute, MAX_SEKUNDE));
    }

    public static UngewisseZeit of(int stunde, int minute, int sekunde) {
        return new UngewisseZeit(LocalTime.of(stunde, minute, sekunde), LocalTime.of(stunde, minute, sekunde));
    }

    public static UngewisseZeit of(LocalTime vonInklusive, LocalTime bisInklusive) {
        Objects.requireNonNull(vonInklusive);
        Objects.requireNonNull(bisInklusive);
        if (vonInklusive.isAfter(bisInklusive)) {
            throw new DateTimeException("Der Anfang " + vonInklusive + " liegt nach dem Ende " + bisInklusive + ".");
        }
        return new UngewisseZeit(vonInklusive, bisInklusive);
    }

    public boolean isLeer() {
        return this.anfang == null && this.ende == null;
    }

    public boolean isUngewiss() {
        return this.anfang == null || !this.anfang.equals(this.ende);
    }

    public LocalTime getAnfang() {
        return this.anfang;
    }

    public LocalTime getEnde() {
        return this.ende;
    }

    public Optional<Integer> getStunde() {
        if (this.nurStundeBekannt()) {
            return Optional.of(this.anfang.getHour());
        }
        return Optional.empty();
    }

    public Optional<Integer> getMinute() {
        if (this.nurMinuteUndStundeBekannt()) {
            return Optional.of(this.anfang.getMinute());
        }
        return Optional.empty();
    }

    public Optional<Integer> getSekunde() {
        if (this.isUngewiss()) {
            return Optional.empty();
        }
        return Optional.of(this.anfang.getSecond());
    }

    public Optional<LocalTime> toLocalTime() {
        if (this.isUngewiss()) {
            return Optional.empty();
        }
        return Optional.of(this.anfang);
    }

    public static UngewisseZeit parse(String text) {
        Objects.requireNonNull(text);
        if (text.isEmpty()) {
            throw new DateTimeParseException("Der String war leer.", text, 0);
        }
        TemporalAccessor ta = format.parse(text);
        if (ta.isSupported(ChronoField.SECOND_OF_MINUTE) && ta.get(ChronoField.SECOND_OF_MINUTE) != 0) {
            return UngewisseZeit.of(ta.get(ChronoField.HOUR_OF_DAY), ta.get(ChronoField.MINUTE_OF_HOUR), ta.get(ChronoField.SECOND_OF_MINUTE));
        }
        if (ta.isSupported(ChronoField.MINUTE_OF_HOUR) && ta.get(ChronoField.MINUTE_OF_HOUR) != 0) {
            return UngewisseZeit.of(ta.get(ChronoField.HOUR_OF_DAY), ta.get(ChronoField.MINUTE_OF_HOUR));
        }
        if (ta.isSupported(ChronoField.HOUR_OF_DAY)) {
            return UngewisseZeit.of(ta.get(ChronoField.HOUR_OF_DAY));
        }
        return UngewisseZeit.leer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UngewisseZeit)) {
            return false;
        }
        UngewisseZeit that = (UngewisseZeit)o;
        return Objects.equals(this.anfang, that.anfang) && Objects.equals(this.ende, that.ende);
    }

    public int hashCode() {
        return Objects.hash(this.anfang, this.ende);
    }

    public String toString() {
        DateTimeFormatter HHmmss = DateTimeFormatter.ofPattern("HH:mm:ss");
        String toString = this.isLeer() ? "xx:xx:xx" : (this.anfang.equals(this.ende) ? this.anfang.format(HHmmss) : (this.nurStundeBekannt() ? String.format("%02d:xx:xx", this.anfang.getHour()) : (this.nurMinuteUndStundeBekannt() ? String.format("%02d:%02d:xx", this.anfang.getHour(), this.anfang.getMinute()) : String.format("%s - %s", this.anfang.format(HHmmss), this.ende.format(HHmmss)))));
        return toString;
    }

    private boolean nurMinuteUndStundeBekannt() {
        return this.anfang != null && this.anfang.getSecond() == 0 && this.anfang.plusMinutes(1L).equals(this.ende.plusSeconds(1L));
    }

    private boolean nurStundeBekannt() {
        return this.anfang != null && this.anfang.getMinute() == 0 && this.anfang.getSecond() == 0 && this.anfang.plusHours(1L).equals(this.ende.plusSeconds(1L));
    }
}

