/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.datetime.format;

import java.time.Duration;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class OutFormat {
    public static final DateTimeFormatter DATUM_ZEIT_LANG_TAG_ZONE = DateTimeFormatter.ofPattern("cccc, dd. MMMM uuuu HH:mm:ss z", Locale.GERMAN);
    public static final DateTimeFormatter DATUM_ZEIT_LANG_TAG = DateTimeFormatter.ofPattern("cccc, dd. MMMM uuuu HH:mm:ss", Locale.GERMAN);
    public static final DateTimeFormatter DATUM_ZEIT_LANG_ZONE = DateTimeFormatter.ofPattern("dd. MMMM uuuu HH:mm:ss z", Locale.GERMAN);
    public static final DateTimeFormatter DATUM_ZEIT_ZONE = DateTimeFormatter.ofPattern("dd.MM.uuuu HH:mm:ss xxx", Locale.GERMAN);
    public static final DateTimeFormatter DATUM_ZEIT = DateTimeFormatter.ofPattern("dd.MM.uuuu HH:mm:ss", Locale.GERMAN);
    public static final DateTimeFormatter DATUM = DateTimeFormatter.ofPattern("dd.MM.uuuu", Locale.GERMAN);
    public static final DateTimeFormatter ZEIT = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.GERMAN);
    public static final DateTimeFormatter ZEIT_KURZ = DateTimeFormatter.ofPattern("HH:mm", Locale.GERMAN);
    private static final Map<TemporalUnit, String> zeiteinheitenAbkuerzungen = new HashMap<TemporalUnit, String>();

    public static String toDauerString(Period period) {
        Objects.requireNonNull(period);
        return period.getUnits().stream().filter(unit -> period.get((TemporalUnit)unit) > 0L).map(unit -> period.get((TemporalUnit)unit) + zeiteinheitenAbkuerzungen.get(unit)).collect(Collectors.joining(" "));
    }

    public static String toDauerString(Duration duration) {
        LinkedHashMap<ChronoUnit, Long> einzelwerte = new LinkedHashMap<ChronoUnit, Long>();
        Long stunden = duration.toHours();
        einzelwerte.put(ChronoUnit.HOURS, stunden);
        duration = duration.minusHours(stunden);
        Long minuten = duration.toMinutes();
        einzelwerte.put(ChronoUnit.MINUTES, minuten);
        duration = duration.minusMinutes(minuten);
        einzelwerte.put(ChronoUnit.SECONDS, duration.getSeconds());
        einzelwerte.put(ChronoUnit.MILLIS, Math.round((double)duration.getNano() / 1000000.0));
        return einzelwerte.entrySet().stream().filter(e -> (Long)e.getValue() > 0L).map(e -> e.getValue() + zeiteinheitenAbkuerzungen.get(e.getKey())).collect(Collectors.joining(" "));
    }

    static {
        zeiteinheitenAbkuerzungen.put(ChronoUnit.MILLIS, "ms");
        zeiteinheitenAbkuerzungen.put(ChronoUnit.SECONDS, "s");
        zeiteinheitenAbkuerzungen.put(ChronoUnit.MINUTES, "min");
        zeiteinheitenAbkuerzungen.put(ChronoUnit.HOURS, "h");
        zeiteinheitenAbkuerzungen.put(ChronoUnit.DAYS, "d");
        zeiteinheitenAbkuerzungen.put(ChronoUnit.MONTHS, "M");
        zeiteinheitenAbkuerzungen.put(ChronoUnit.YEARS, "a");
    }
}

