/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.datetime.format;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class InFormat {
    public static final DateTimeFormatter DATUM_D_M_Y = DateTimeFormatter.ofPattern("d.M.u");
    public static final DateTimeFormatter DATUM_D_M_YY = DateTimeFormatter.ofPattern("d.M.uu");
    public static final DateTimeFormatter DATUM_D_M_YYY = DateTimeFormatter.ofPattern("d.M.uuu");
    public static final DateTimeFormatter DATUM_D_M_YYYY = DateTimeFormatter.ofPattern("d.M.uuuu");
    public static final DateTimeFormatter DATUM_DD_MM_Y = DateTimeFormatter.ofPattern("dd.MM.u");
    public static final DateTimeFormatter DATUM_DD_MM_YY = DateTimeFormatter.ofPattern("dd.MM.uu");
    public static final DateTimeFormatter DATUM_DD_MM_YYY = DateTimeFormatter.ofPattern("dd.MM.uuu");
    public static final DateTimeFormatter DATUM_DD_MM_YYYY = DateTimeFormatter.ofPattern("dd.MM.uuuu");
    public static final DateTimeFormatter ZEIT = DateTimeFormatter.ofPattern("H:mm");
    public static final DateTimeFormatter ZEIT_SEK = DateTimeFormatter.ofPattern("H:mm:ss");
    public static final DateTimeFormatter ZEIT_SEK_MILLISEK = DateTimeFormatter.ofPattern("H:mm:ss.SSS");
    public static final DateTimeFormatter ZEIT_SEK_MIKROSEK = DateTimeFormatter.ofPattern("H:mm:ss.SSSSSS");
    public static final DateTimeFormatter ZEIT_SEK_NANOSEK = DateTimeFormatter.ofPattern("H:mm:ss.SSSSSSSSS");
    public static final DateTimeFormatter ZEIT_OFFSET = DateTimeFormatter.ofPattern("H:mm xxx");
    public static final DateTimeFormatter ZEIT_SEK_OFFSET = DateTimeFormatter.ofPattern("H:mm:ss xxx");
    public static final DateTimeFormatter ZEIT_SEK_MILLISEK_OFFSET = DateTimeFormatter.ofPattern("H:mm:ss.SSS xxx");
    public static final DateTimeFormatter ZEIT_SEK_MIKROSEK_OFFSET = DateTimeFormatter.ofPattern("H:mm:ss.SSSSSS xxx");
    public static final DateTimeFormatter ZEIT_SEK_NANOSEK_OFFSET = DateTimeFormatter.ofPattern("H:mm:ss.SSSSSSSSS xxx");
    public static final DateTimeFormatter ZEIT_0H = DateTimeFormatter.ofPattern("HH:mm");
    public static final DateTimeFormatter ZEIT_0H_SEK = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter ZEIT_0H_SEK_MILLISEK = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    public static final DateTimeFormatter ZEIT_0H_SEK_MIKROSEK = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");
    public static final DateTimeFormatter ZEIT_0H_SEK_NANOSEK = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS");
    public static final DateTimeFormatter ZEIT_0H_OFFSET = DateTimeFormatter.ofPattern("HH:mm xxx");
    public static final DateTimeFormatter ZEIT_0H_SEK_OFFSET = DateTimeFormatter.ofPattern("HH:mm:ss xxx");
    public static final DateTimeFormatter ZEIT_0H_SEK_MILLISEK_OFFSET = DateTimeFormatter.ofPattern("HH:mm:ss.SSS xxx");
    public static final DateTimeFormatter ZEIT_0H_SEK_MIKROSEK_OFFSET = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS xxx");
    public static final DateTimeFormatter ZEIT_0H_SEK_NANOSEK_OFFSET = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS xxx");
    public static final DateTimeFormatter ZEIT_0H_ZONE = DateTimeFormatter.ofPattern("HH:mm z");
    public static final DateTimeFormatter ZEIT_0H_SEK_ZONE = DateTimeFormatter.ofPattern("HH:mm:ss z");
    public static final DateTimeFormatter ZEIT_0H_SEK_MILLISEK_ZONE = DateTimeFormatter.ofPattern("HH:mm:ss.SSS z");
    public static final DateTimeFormatter ZEIT_0H_SEK_MIKROSEK_ZONE = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS z");
    public static final DateTimeFormatter ZEIT_0H_SEK_NANOSEK_ZONE = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSSSSS z");
    private static final DateTimeFormatter datumFormatter = DateTimeFormatter.ofPattern("d[d].M[M].[u][uu][uuu][uuuu]");
    private static final DateTimeFormatter zeitFormatter = DateTimeFormatter.ofPattern("H[H]:mm[:ss[.SSSSSSSSS][.SSSSSS][.SSS]][ xxx][ z]");
    private static final DateTimeFormatter datumZeitFormatter = DateTimeFormatter.ofPattern("d[d].M[M].[u][uu][uuu][uuuu] H[H]:mm[:ss[.SSSSSSSSS][.SSSSSS][.SSS]][ xxx][ z]");

    public static LocalTime parseToLocalTime(String text) {
        return zeitFormatter.parse((CharSequence)text, LocalTime::from);
    }

    public static OffsetTime parseToOffsetTime(String text) {
        return zeitFormatter.parse((CharSequence)text, OffsetTime::from);
    }

    public static LocalDate parseToLocalDate(String text) {
        return datumFormatter.parse((CharSequence)text, LocalDate::from);
    }

    public static LocalDateTime parseToLocalDateTime(String text) {
        return datumZeitFormatter.parse((CharSequence)text, LocalDateTime::from);
    }

    public static OffsetDateTime parseToOffsetDateTime(String text) {
        return datumZeitFormatter.parse((CharSequence)text, OffsetDateTime::from);
    }

    public static ZonedDateTime parseToZonedDateTime(String text) {
        return datumZeitFormatter.parse((CharSequence)text, ZonedDateTime::from);
    }

    public static Period parseToPeriod(String text) {
        Objects.requireNonNull(text);
        ConcurrentHashMap<ChronoUnit, Pattern> einheitenPattern = new ConcurrentHashMap<ChronoUnit, Pattern>();
        einheitenPattern.put(ChronoUnit.YEARS, Pattern.compile("(\\d+)a"));
        einheitenPattern.put(ChronoUnit.MONTHS, Pattern.compile("(\\d+)M"));
        einheitenPattern.put(ChronoUnit.DAYS, Pattern.compile("(\\d+)d"));
        Map<ChronoUnit, Integer> einheitenWerte = InFormat.parseDauer(text, einheitenPattern);
        return Period.of(einheitenWerte.get(ChronoUnit.YEARS), einheitenWerte.get(ChronoUnit.MONTHS), einheitenWerte.get(ChronoUnit.DAYS));
    }

    public static Duration parseToDuration(String text) {
        Objects.requireNonNull(text);
        ConcurrentHashMap<ChronoUnit, Pattern> einheitenPattern = new ConcurrentHashMap<ChronoUnit, Pattern>();
        einheitenPattern.put(ChronoUnit.HOURS, Pattern.compile("(\\d+)h"));
        einheitenPattern.put(ChronoUnit.MINUTES, Pattern.compile("(\\d+)min"));
        einheitenPattern.put(ChronoUnit.SECONDS, Pattern.compile("(\\d+)s"));
        einheitenPattern.put(ChronoUnit.MILLIS, Pattern.compile("(\\d+)ms"));
        Map<ChronoUnit, Integer> einheitenWerte = InFormat.parseDauer(text, einheitenPattern);
        return Duration.ofHours(einheitenWerte.get(ChronoUnit.HOURS).intValue()).plusMinutes(einheitenWerte.get(ChronoUnit.MINUTES).intValue()).plusSeconds(einheitenWerte.get(ChronoUnit.SECONDS).intValue()).plusMillis(einheitenWerte.get(ChronoUnit.MILLIS).intValue());
    }

    private static Map<ChronoUnit, Integer> parseDauer(String s, ConcurrentMap<ChronoUnit, Pattern> einheitenPattern) {
        List<String> teile = Arrays.asList(s.trim().split("\\s+"));
        EnumMap<ChronoUnit, Integer> einheitenWerte = new EnumMap<ChronoUnit, Integer>(ChronoUnit.class);
        einheitenPattern.forEach((einheit, v) -> einheitenWerte.put((ChronoUnit)einheit, 0));
        for (String teil : teile) {
            boolean noMatch = true;
            for (Map.Entry einheit2 : einheitenPattern.entrySet()) {
                Matcher matcher = ((Pattern)einheit2.getValue()).matcher(teil);
                if (!matcher.matches()) continue;
                einheitenPattern.remove(einheit2.getKey());
                einheitenWerte.put((ChronoUnit)einheit2.getKey(), Integer.parseInt(matcher.group(1)));
                noMatch = false;
                break;
            }
            if (!noMatch) continue;
            throw new DateTimeParseException(null, s, s.indexOf(teil));
        }
        return einheitenWerte;
    }
}

