/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.datetime.core;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.Optional;

public class UngewissesDatum {
    private static final DateTimeFormatter format = new DateTimeFormatterBuilder().appendPattern("[00.00.0000]").appendPattern("[00.00.yyyy]").appendPattern("[00.MM.yyyy]").appendPattern("['xx.xx.xxxx']").appendPattern("['xx.xx.'yyyy]").appendPattern("['xx.'MM.yyyy]").appendPattern("[dd.MM.yyyy]").parseStrict().toFormatter();
    private static final int minMonth = (int)ChronoField.MONTH_OF_YEAR.range().getMinimum();
    private static final int minDayOfMonth = (int)ChronoField.DAY_OF_MONTH.range().getMinimum();
    private LocalDate anfang;
    private LocalDate ende;

    private UngewissesDatum() {
    }

    private UngewissesDatum(int jahr) {
        this.anfang = LocalDate.of(jahr, minMonth, minDayOfMonth);
        this.ende = this.anfang.plusYears(1L).minusDays(1L);
    }

    private UngewissesDatum(int jahr, int monat) {
        this.anfang = LocalDate.of(jahr, monat, minDayOfMonth);
        this.ende = this.anfang.plusMonths(1L).minusDays(1L);
    }

    private UngewissesDatum(int jahr, int monat, int tag) {
        this.anfang = LocalDate.of(jahr, monat, tag);
        this.ende = LocalDate.of(jahr, monat, tag);
    }

    private UngewissesDatum(LocalDate anfang, LocalDate ende) {
        this.anfang = anfang;
        this.ende = ende;
    }

    public static UngewissesDatum leer() {
        return new UngewissesDatum();
    }

    public boolean isLeer() {
        return this.anfang == null && this.ende == null;
    }

    public boolean isUngewiss() {
        return this.anfang == null || !this.anfang.isEqual(this.ende);
    }

    public static UngewissesDatum of(int jahr) {
        return new UngewissesDatum(jahr);
    }

    public static UngewissesDatum of(int jahr, int monat) {
        return new UngewissesDatum(jahr, monat);
    }

    public static UngewissesDatum of(int jahr, int monat, int tag) {
        return new UngewissesDatum(jahr, monat, tag);
    }

    public static UngewissesDatum of(LocalDate vonInklusive, LocalDate bisInklusive) {
        Objects.requireNonNull(vonInklusive);
        Objects.requireNonNull(bisInklusive);
        if (bisInklusive.isBefore(vonInklusive)) {
            throw new DateTimeException("Der Anfang " + vonInklusive + " liegt nach dem Ende " + bisInklusive + ".");
        }
        if (vonInklusive.getYear() != bisInklusive.getYear()) {
            throw new DateTimeException("Der Anfang " + vonInklusive + " und das Ende " + bisInklusive + " m\u00fcssen innerhalb des gleiche Jahres sein.");
        }
        return new UngewissesDatum(vonInklusive, bisInklusive);
    }

    public static UngewissesDatum parse(String text) {
        Objects.requireNonNull(text);
        if (text.isEmpty()) {
            throw new DateTimeParseException("Der String war leer.", text, 0);
        }
        TemporalAccessor ta = format.parse(text);
        if (ta.isSupported(ChronoField.DAY_OF_MONTH)) {
            return UngewissesDatum.of(ta.get(ChronoField.YEAR), ta.get(ChronoField.MONTH_OF_YEAR), ta.get(ChronoField.DAY_OF_MONTH));
        }
        if (ta.isSupported(ChronoField.MONTH_OF_YEAR)) {
            return UngewissesDatum.of(ta.get(ChronoField.YEAR), ta.get(ChronoField.MONTH_OF_YEAR));
        }
        if (ta.isSupported(ChronoField.YEAR)) {
            return UngewissesDatum.of(ta.get(ChronoField.YEAR));
        }
        return UngewissesDatum.leer();
    }

    public Optional<Integer> getJahr() {
        if (this.anfang != null || this.nurJahrBekannt()) {
            return Optional.of(this.anfang.getYear());
        }
        return Optional.empty();
    }

    public Optional<Integer> getMonat() {
        if (this.anfang != null && this.anfang.getMonth() == this.ende.getMonth() || this.nurMonatUndJahrBekannt()) {
            return Optional.of(this.anfang.getMonthValue());
        }
        return Optional.empty();
    }

    public Optional<Integer> getTag() {
        if (this.isUngewiss()) {
            return Optional.empty();
        }
        return Optional.of(this.anfang.getDayOfMonth());
    }

    public Optional<LocalDate> toLocalDate() {
        if (this.isUngewiss()) {
            return Optional.empty();
        }
        return Optional.of(LocalDate.of(this.anfang.getYear(), this.anfang.getMonth(), this.anfang.getDayOfMonth()));
    }

    public LocalDate getAnfang() {
        return this.anfang;
    }

    public LocalDate getEnde() {
        return this.ende;
    }

    public String toString() {
        DateTimeFormatter ddMMuuuu = DateTimeFormatter.ofPattern("dd.MM.uuuu");
        String toString = this.isLeer() ? "xx.xx.xxxx" : (this.anfang.equals(this.ende) ? this.anfang.format(ddMMuuuu) : (this.nurJahrBekannt() ? String.format("xx.xx.%04d", this.anfang.getYear()) : (this.nurMonatUndJahrBekannt() ? String.format("xx.%02d.%04d", this.anfang.getMonthValue(), this.anfang.getYear()) : String.format("%s - %s", this.anfang.format(ddMMuuuu), this.ende.format(ddMMuuuu)))));
        return toString;
    }

    private boolean nurJahrBekannt() {
        return this.anfang != null && this.anfang.getDayOfMonth() == 1 && this.anfang.getMonthValue() == 1 && this.anfang.plusYears(1L).minusDays(1L).isEqual(this.ende);
    }

    private boolean nurMonatUndJahrBekannt() {
        return this.anfang != null && this.anfang.getDayOfMonth() == 1 && this.anfang.plusMonths(1L).minusDays(1L).isEqual(this.ende);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UngewissesDatum)) {
            return false;
        }
        UngewissesDatum that = (UngewissesDatum)o;
        return Objects.equals(this.anfang, that.anfang) && Objects.equals(this.ende, that.ende);
    }

    public int hashCode() {
        return Objects.hash(this.anfang, this.ende);
    }
}

