/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.datetime.util;

import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Objects;

public abstract class DateTimeUtil {
    private static Clock clock = Clock.systemDefaultZone();

    public static Clock getClock() {
        return clock;
    }

    public static void setClock(Clock clock) {
        Objects.requireNonNull(clock);
        DateTimeUtil.clock = clock;
    }

    public static boolean datumLiegtZwischen(LocalDate datum, LocalDate anfang, LocalDate ende) {
        Objects.requireNonNull(datum);
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(ende);
        if (ende.isBefore(anfang)) {
            throw new DateTimeException("Das Enddatum " + ende + " liegt vor dem Anfangsdatum " + anfang);
        }
        return !(!datum.isEqual(anfang) && !datum.isAfter(anfang) || !datum.isBefore(ende) && !datum.isEqual(ende));
    }

    public static boolean datumLiegtZwischenExklusive(LocalDate datum, LocalDate anfang, LocalDate ende) {
        Objects.requireNonNull(datum);
        Objects.requireNonNull(anfang);
        Objects.requireNonNull(ende);
        if (ende.isBefore(anfang)) {
            throw new DateTimeException("Das Enddatum " + ende + " liegt vor dem Anfangsdatum " + anfang);
        }
        return datum.isAfter(anfang) && datum.isBefore(ende);
    }

    public static LocalDate getJahresanfang(LocalDate datum) {
        return datum == null ? null : datum.withDayOfYear(1);
    }

    public static LocalDate getMonatsanfang(LocalDate datum) {
        return datum == null ? null : datum.withDayOfMonth(1);
    }

    public static LocalDate getMonatsende(LocalDate datum) {
        return datum == null ? null : datum.withDayOfMonth(datum.getMonth().length(datum.isLeapYear()));
    }

    public static LocalDate getWerktag(LocalDate datum) {
        Objects.requireNonNull(datum);
        return datum.getDayOfWeek() == DayOfWeek.SUNDAY ? datum.plusDays(1L) : datum;
    }

    public static LocalTime localTimeNow() {
        return LocalTime.now(clock);
    }

    public static LocalDate localDateNow() {
        return LocalDate.now(clock);
    }

    public static LocalDateTime localDateTimeNow() {
        return LocalDateTime.now(clock);
    }

    public static OffsetTime offsetTimeNow() {
        return OffsetTime.now(clock);
    }

    public static OffsetDateTime offsetDateTimeNow() {
        return OffsetDateTime.now(clock);
    }

    public static ZonedDateTime zonedDateTimeNow() {
        return ZonedDateTime.now(clock);
    }
}

