/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.datetime.test;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public class TestClock
extends Clock {
    private Instant instant;
    private ZoneId zoneId;

    private TestClock(Instant instant, ZoneId zoneId) {
        this.instant = instant;
        this.zoneId = zoneId;
    }

    public static TestClock at(Instant instant, ZoneId zoneId) {
        Objects.requireNonNull(instant);
        Objects.requireNonNull(zoneId);
        return new TestClock(Objects.requireNonNull(instant), Objects.requireNonNull(zoneId));
    }

    public static TestClock at(LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime);
        return TestClock.at(localDateTime.atZone(ZoneId.systemDefault()));
    }

    public static TestClock at(LocalDateTime localDateTime, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime);
        Objects.requireNonNull(zoneId);
        return TestClock.at(localDateTime.atZone(zoneId));
    }

    public static TestClock at(OffsetDateTime offsetDateTime) {
        Objects.requireNonNull(offsetDateTime);
        return TestClock.at(offsetDateTime.toZonedDateTime());
    }

    public static TestClock at(ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime);
        return new TestClock(zonedDateTime.toInstant(), zonedDateTime.getZone());
    }

    public static TestClock now(ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        return new TestClock(Instant.now(), zoneId);
    }

    public static TestClock now() {
        return new TestClock(Instant.now(), ZoneId.systemDefault());
    }

    public TestClock advanceBy(Duration duration) {
        Objects.requireNonNull(duration);
        this.instant = ZonedDateTime.ofInstant(this.instant, this.zoneId).plus(duration).toInstant();
        return this;
    }

    public TestClock advanceBy(Period period) {
        Objects.requireNonNull(period);
        this.instant = ZonedDateTime.ofInstant(this.instant, this.zoneId).plus(period).toInstant();
        return this;
    }

    @Override
    public ZoneId getZone() {
        return this.zoneId;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new TestClock(this.instant, zone);
    }

    @Override
    public Instant instant() {
        return this.instant;
    }

    public String toString() {
        return "TestClock: " + ZonedDateTime.ofInstant(this.instant, this.zoneId).toString();
    }
}

