/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.pc.view;

import de.bright_side.lgf.base.LLogger;
import de.bright_side.lgf.base.LPlatform;
import de.bright_side.lgf.model.LObject;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.pc.base.LPcUtil;
import de.bright_side.lgf.pc.view.LPcCanvas;
import de.bright_side.lgf.util.LMathsUtil;
import de.bright_side.lgf.view.LCanvas;
import de.bright_side.lgf.view.LScreenView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;

public class LPcViewComponent
extends JComponent {
    private static final long serialVersionUID = -7513394895347926330L;
    private LLogger logger;
    private LScreenView screenView;
    private LVector virtualSize;
    private LVector lastTouchPos;
    private LVector dragStartPos;
    private LVector moveAmountSinceDragStart;
    private LVector clickPos;
    private LVector touchDownPos;
    private boolean mouseDown = false;
    private List<LObject> touchedObjects;
    private boolean backPressed;

    public LPcViewComponent(LPlatform platform, LVector virtualSize) {
        this.logger = platform.getLogger();
        this.virtualSize = virtualSize;
        this.addMouseMotionListener(this.createMouseMotionListener());
        this.addMouseListener(this.createMouseListener());
    }

    private LVector getPos(MouseEvent event) {
        LVector pos = new LVector(event.getX(), event.getY());
        pos = LMathsUtil.divide((LVector)pos, (LVector)this.getSizeAsVector());
        pos = LMathsUtil.multiply((LVector)pos, (LVector)this.virtualSize);
        return pos;
    }

    private LVector getSizeAsVector() {
        return new LVector(this.getWidth(), this.getHeight());
    }

    private MouseListener createMouseListener() {
        return new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.getButton() == 1) {
                    LPcViewComponent.this.moveAmountSinceDragStart = null;
                    LPcViewComponent.this.mouseDown = false;
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                LVector pos = LPcViewComponent.this.getPos(event);
                LPcViewComponent.this.lastTouchPos = pos;
                LPcViewComponent.this.dragStartPos = pos;
                if (event.getButton() == 1) {
                    LPcViewComponent.this.mouseDown = true;
                    if (LPcViewComponent.this.touchedObjects == null) {
                        LPcViewComponent.this.touchedObjects = LPcViewComponent.this.screenView.getTouchedObjects(LPcUtil.applyCameraPos(pos, LPcViewComponent.this.virtualSize, LPcViewComponent.this.screenView), pos);
                    }
                    LPcViewComponent.this.clickPos = pos;
                    LPcViewComponent.this.touchDownPos = pos;
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        };
    }

    private MouseMotionListener createMouseMotionListener() {
        return new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                LVector pos = LPcViewComponent.this.getPos(event);
                LPcViewComponent.this.moveAmountSinceDragStart = LMathsUtil.subtract((LVector)pos, (LVector)LPcViewComponent.this.dragStartPos);
                LPcViewComponent.this.lastTouchPos = pos;
            }
        };
    }

    public void setVirtualSize(LVector virtualSize) {
        this.virtualSize = virtualSize;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.screenView != null) {
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            rh.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            rh.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            rh.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            ((Graphics2D)g).setRenderingHints(rh);
            this.screenView.draw((LCanvas)new LPcCanvas(this.logger, this.virtualSize, (Graphics2D)g, new LVector(this.getWidth(), this.getHeight()), this.screenView.getCameraPos()));
        }
    }

    public void setScreenView(LScreenView screenView) {
        this.screenView = screenView;
    }

    public void update(long millisSinceLastUpdate) {
        this.repaint();
    }

    public LVector getDragMoveAmount() {
        return this.moveAmountSinceDragStart;
    }

    public LVector getClickPos() {
        return this.clickPos;
    }

    public List<LObject> getTouchedObjects() {
        return this.touchedObjects;
    }

    public void resetEvents() {
        this.clickPos = null;
        this.touchedObjects = null;
        this.backPressed = false;
    }

    public void setBackPressed(boolean backPressed) {
        this.backPressed = backPressed;
    }

    public boolean isBackPressed() {
        return this.backPressed;
    }

    public boolean isMouseDown() {
        return this.mouseDown;
    }

    public void setMouseDown(boolean mouseDown) {
        this.mouseDown = mouseDown;
    }

    public LVector getLastTouchPos() {
        return this.lastTouchPos;
    }

    public LVector getTouchDownPos() {
        return this.touchDownPos;
    }
}

