/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.pc.view;

import de.bright_side.lgf.base.LPlatform;
import de.bright_side.lgf.model.LInput;
import de.bright_side.lgf.model.LPointer;
import de.bright_side.lgf.model.LRenderStatistics;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.pc.base.LPcInstance;
import de.bright_side.lgf.pc.base.LPcPlatform;
import de.bright_side.lgf.pc.view.LPcViewComponent;
import de.bright_side.lgf.presenter.LScreenPresenter;
import de.bright_side.lgf.util.LErrorListener;
import de.bright_side.lgf.util.LMathsUtil;
import de.bright_side.lgf.util.LUtil;
import de.bright_side.lgf.view.LScreenView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LPcMainWindow
extends JFrame {
    private static final boolean LOGGING_ENABLED = true;
    private static final long serialVersionUID = 1881881724769110985L;
    private static final int DECORATION_HEIGHT = 50;
    private static final int DECORATION_WIDTH = 20;
    private static final double MILLIS_PER_SECOND = 1000.0;
    private LVector virtualSize;
    private LScreenView screenView;
    private LScreenPresenter currentPresenter;
    private LPcViewComponent viewComponent;
    private LVector windowContentSize;
    private LPcInstance instance;
    private LVector lastTouchPosSendInUpdate;

    public LPcMainWindow(LPcInstance instance, boolean resume) {
        this.instance = instance;
        this.virtualSize = instance.getVirtualSize();
        this.windowContentSize = instance.getWindowContentSize();
        try {
            this.setTitle(instance.getWindowTitle());
            this.setDefaultCloseOperation(0);
            this.getContentPane().setLayout(new BorderLayout());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    if (LPcMainWindow.this.currentPresenter != null) {
                        LPcMainWindow.this.currentPresenter.onClose();
                    }
                    System.exit(0);
                }
            });
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 27 && LPcMainWindow.this.viewComponent != null) {
                        LPcMainWindow.this.viewComponent.setBackPressed(true);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    public void init(LPcPlatform platform) {
        this.screenView = new LScreenView((LPlatform)platform, this.virtualSize, this.instance.getScaleFactor());
        this.currentPresenter = this.instance.createFirstScreenPresenter(platform, this.screenView);
        if (this.currentPresenter == null) {
            throw new RuntimeException("the method createFirstScreenPresenter that is overwritten by the developer who uses LGF returned null");
        }
        this.viewComponent = new LPcViewComponent(platform, this.virtualSize);
        this.viewComponent.setScreenView(this.screenView);
        this.getContentPane().add((Component)this.viewComponent, "Center");
        this.setSize((int)this.windowContentSize.x + 20, (int)this.windowContentSize.y + 50);
        this.setLocationRelativeTo(null);
        this.startUpdateThread();
        this.log("init complete");
    }

    private void log(String message) {
        System.out.println("LPcMainWindow> " + message);
    }

    private void startUpdateThread() {
        final LErrorListener errorListener = new LErrorListener(){

            public void onError(Throwable t) {
                LPcMainWindow.this.handleError(t);
            }
        };
        new Thread(){

            @Override
            public void run() {
                long desiredTimeBetweenIterations = 15L;
                long remainingSleepTime = 0L;
                long lastTime = System.nanoTime() / 1000000L;
                long updateDuration = 0L;
                long drawDuration = 0L;
                block4: while (true) {
                    try {
                        while (true) {
                            long currentTime = System.nanoTime() / 1000000L;
                            LInput input = LPcMainWindow.this.buildInput();
                            LRenderStatistics statistics = new LRenderStatistics(remainingSleepTime, drawDuration, updateDuration);
                            LUtil.callTouchedActions((List)input.getTouchedObjects(), (LErrorListener)errorListener);
                            if (LPcMainWindow.this.currentPresenter != null) {
                                LPcMainWindow.this.currentPresenter.update(input, (double)(currentTime - lastTime) / 1000.0, statistics);
                            }
                            long timeAfterUpdate = System.nanoTime() / 1000000L;
                            updateDuration = timeAfterUpdate - currentTime;
                            if (LPcMainWindow.this.viewComponent != null) {
                                LPcMainWindow.this.viewComponent.update(currentTime - lastTime);
                            }
                            lastTime = currentTime;
                            drawDuration = System.nanoTime() / 1000000L - timeAfterUpdate;
                            long passedTime = System.nanoTime() / 1000000L - currentTime;
                            remainingSleepTime = desiredTimeBetweenIterations - passedTime;
                            try {
                                Thread.sleep(Math.max(remainingSleepTime, 0L));
                                continue block4;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        LPcMainWindow.this.handleError(t);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private <T> Map<Integer, T> singleItemMap(T item) {
        HashMap<Integer, T> result = new HashMap<Integer, T>();
        result.put(1, item);
        return result;
    }

    private LInput buildInput() {
        LInput result = new LInput();
        result.setBackButtonPressed(this.viewComponent.isBackPressed());
        result.setTouchedObjects(this.viewComponent.getTouchedObjects());
        if (!this.viewComponent.isMouseDown()) {
            this.viewComponent.resetEvents();
            result.setPointers(new HashMap());
            this.lastTouchPosSendInUpdate = null;
            return result;
        }
        LPointer pointer = new LPointer();
        result.setWasTouched(this.viewComponent.getClickPos() != null);
        pointer.setTouchDownPos(this.viewComponent.getTouchDownPos());
        if (this.viewComponent.getDragMoveAmount() != null) {
            pointer.setDragDistance(this.viewComponent.getDragMoveAmount());
        } else {
            pointer.setDragDistance(new LVector(0, 0));
        }
        LVector currentTouchPos = this.viewComponent.getLastTouchPos();
        if (this.lastTouchPosSendInUpdate == null) {
            pointer.setMovement(new LVector(0, 0));
        } else {
            pointer.setMovement(LMathsUtil.subtract((LVector)this.lastTouchPosSendInUpdate, (LVector)currentTouchPos));
        }
        pointer.setPos(currentTouchPos);
        result.setPointers(this.singleItemMap(pointer));
        this.lastTouchPosSendInUpdate = currentTouchPos;
        this.viewComponent.resetEvents();
        return result;
    }

    private void handleError(Throwable t) {
        if (t != null) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error: " + t.getMessage() + "\nSee console/log for details");
        }
    }

    public void setPresenter(LScreenPresenter presenter) {
        this.currentPresenter = presenter;
    }
}

