/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.pc.base;

import de.bright_side.lgf.model.LAnimationFrame;
import de.bright_side.lgf.model.LAnimationResource;
import de.bright_side.lgf.model.LFont;
import de.bright_side.lgf.model.LFontResource;
import de.bright_side.lgf.model.LImage;
import de.bright_side.lgf.model.LImageResource;
import de.bright_side.lgf.model.LRawResource;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.pc.base.LPcInstance;
import de.bright_side.lgf.pc.base.PCResourceProperties;
import de.bright_side.lgf.pc.model.LPcAnimationResourceProperties;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;

public class LPcResourceAccess {
    private static final boolean LOGGING_ENABLED = true;
    private Map<LImageResource, String> imageResourceMap;
    private Map<LRawResource, List<PCResourceProperties>> rawResourceMap;
    private Map<LAnimationResource, LPcAnimationResourceProperties> animationResourceMap;
    private Map<LFontResource, Font> fontResourceMap;
    private Map<LAnimationResource, List<LAnimationFrame>> animationResourceCache = new HashMap<LAnimationResource, List<LAnimationFrame>>();
    private Map<LImageResource, LImage> imageCache = new HashMap<LImageResource, LImage>();
    private LPcInstance instance;

    public LPcResourceAccess(LPcInstance instance) {
        this.instance = instance;
        this.imageResourceMap = instance.createImageResourceMap();
        this.rawResourceMap = instance.createRawResourceMap();
        this.animationResourceMap = instance.createAnimationResourceMap();
        this.fontResourceMap = instance.createFontResourceMap();
        this.log("consctructor: all resources created");
    }

    private void log(String message) {
        System.out.println("LPcResourceAccess> " + message);
    }

    public int getElementsPerResource(LRawResource rawResource) {
        return this.rawResourceMap.get(rawResource).size();
    }

    public LImage getImage(LImageResource resource) throws Exception {
        if (this.imageCache.containsKey(resource)) {
            return this.imageCache.get(resource);
        }
        String path = this.imageResourceMap.get(resource);
        if (path == null) {
            throw new Exception("Unknown image resource: " + resource);
        }
        LImage result = this.readImage(path, resource.name(), 0.0);
        this.imageCache.put(resource, result);
        return result;
    }

    private LImage readImage(String path, String id, double rotation) throws Exception {
        try (InputStream inputStream = null;){
            inputStream = this.instance.getImageInputStream(path);
            if (inputStream == null) {
                throw new Exception("Could not get input stream for internal file '" + path + "'");
            }
            LImage result = new LImage();
            BufferedImage nativeImage = ImageIO.read(inputStream);
            if (rotation != 0.0) {
                nativeImage = this.rotate(nativeImage, rotation);
            }
            result.setImageObject((Object)nativeImage);
            result.setSize(new LVector(nativeImage.getWidth(), nativeImage.getHeight()));
            result.setId(id);
            LImage lImage = result;
            return lImage;
        }
    }

    private BufferedImage rotate(BufferedImage src, double rotation) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(rotation), src.getWidth() / 2, src.getHeight() / 2);
        BufferedImage rotatedImage = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
        g.setTransform(affineTransform);
        g.drawImage((Image)src, 0, 0, null);
        return rotatedImage;
    }

    public String getRawResourceName(LRawResource rawResource, int index) {
        return this.rawResourceMap.get(rawResource).get(index).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readRawResourceAsUTF8String(LRawResource rawResource, int index) throws Exception {
        InputStream inputStream = null;
        PCResourceProperties properties = this.rawResourceMap.get(rawResource).get(index);
        String path = properties.getPath();
        try {
            int count;
            inputStream = this.instance.getRawResourceInputStream(path);
            if (inputStream == null) {
                throw new Exception("Could not get input stream for internal file '" + path + "'");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int BUFFER = 2048;
            byte[] data = new byte[2048];
            while ((count = inputStream.read(data, 0, 2048)) != -1) {
                outputStream.write(data, 0, count);
            }
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public LFont getFont(LFontResource font) throws Exception {
        LFont result = new LFont();
        result.setFontObject((Object)this.fontResourceMap.get(font));
        result.setId(font.name());
        return result;
    }

    public List<LAnimationFrame> getAnimationFrames(LAnimationResource resource) throws Exception {
        List<LAnimationFrame> result = this.animationResourceCache.get(resource);
        if (result != null) {
            return result;
        }
        result = new ArrayList<LAnimationFrame>();
        LPcAnimationResourceProperties properties = this.animationResourceMap.get(resource);
        double duration = properties.getFrameDurationInSeconds();
        int amount = properties.getFrameImagePaths().size();
        double rotation = properties.getRotation();
        for (int i = 0; i < amount; ++i) {
            String path = properties.getFrameImagePaths().get(i);
            result.add(new LAnimationFrame(this.readImage(path, this.createAnimationID(resource, i), rotation), duration));
        }
        this.animationResourceCache.put(resource, result);
        return result;
    }

    private String createAnimationID(LAnimationResource resource, int index) {
        return "a:" + resource.name() + ":" + index;
    }

    public Map<String, LImage> getIdToImageMap() throws Exception {
        TreeMap<String, LImage> result = new TreeMap<String, LImage>();
        for (Map.Entry<LImageResource, String> i : this.imageResourceMap.entrySet()) {
            LImage image = this.getImage(i.getKey());
            result.put(image.getId(), image);
        }
        for (LAnimationResource animation : this.animationResourceMap.keySet()) {
            for (LAnimationFrame i : this.getAnimationFrames(animation)) {
                result.put(i.getImage().getId(), i.getImage());
            }
        }
        return result;
    }

    public Map<String, LFont> getIdToFontMap() throws Exception {
        TreeMap<String, LFont> result = new TreeMap<String, LFont>();
        for (Map.Entry<LFontResource, Font> i : this.fontResourceMap.entrySet()) {
            LFont font = new LFont();
            font.setFontObject((Object)i.getValue());
            font.setId(i.getKey().name());
            result.put(font.getId(), font);
        }
        return result;
    }
}

