/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.pc.base;

import de.bright_side.filesystemfacade.facade.FSFFile;
import de.bright_side.filesystemfacade.facade.FSFSystem;
import de.bright_side.filesystemfacade.nativefs.NativeFS;
import de.bright_side.lgf.base.LConstants;
import de.bright_side.lgf.base.LLogger;
import de.bright_side.lgf.base.LPlatform;
import de.bright_side.lgf.base.LTextInputResultListener;
import de.bright_side.lgf.model.LAnimationFrame;
import de.bright_side.lgf.model.LAnimationResource;
import de.bright_side.lgf.model.LBuyableItem;
import de.bright_side.lgf.model.LColor;
import de.bright_side.lgf.model.LFont;
import de.bright_side.lgf.model.LFontResource;
import de.bright_side.lgf.model.LImage;
import de.bright_side.lgf.model.LImageResource;
import de.bright_side.lgf.model.LRawResource;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.pc.base.LPcInstance;
import de.bright_side.lgf.pc.base.LPcLogger;
import de.bright_side.lgf.pc.base.LPcResourceAccess;
import de.bright_side.lgf.pc.view.LPcMainWindow;
import de.bright_side.lgf.pc.view.LPcMessagesWindow;
import de.bright_side.lgf.presenter.LScreenPresenter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class LPcPlatform
implements LPlatform {
    private LPcLogger logger = new LPcLogger();
    private LPcResourceAccess resourceAccess;
    private LPcMainWindow mainWindow;
    private FSFSystem fsfSystem = new NativeFS();
    private LPcMessagesWindow messagesWindow = new LPcMessagesWindow();
    private LPcInstance instance;

    public LPcPlatform(LPcInstance instance, LPcMainWindow mainWindow) {
        this.instance = instance;
        this.mainWindow = mainWindow;
    }

    public void init(LPcResourceAccess resourceAccess) {
        this.resourceAccess = resourceAccess;
    }

    public LColor getColorRed() {
        return new LColor(Color.RED.getRGB());
    }

    public LColor getColorYellow() {
        return new LColor(Color.YELLOW.getRGB());
    }

    public LColor getColorBlue() {
        return new LColor(Color.BLUE.getRGB());
    }

    public LColor getColorGreen() {
        return new LColor(Color.GREEN.getRGB());
    }

    public LColor getColorGray() {
        return new LColor(Color.GRAY.getRGB());
    }

    public LColor getColorBlack() {
        return new LColor(Color.BLACK.getRGB());
    }

    public LColor getColorWhite() {
        return new LColor(Color.WHITE.getRGB());
    }

    public LColor getCustomColor(int red, int green, int blue) {
        return new LColor(new Color(red, green, blue).getRGB());
    }

    public LColor getCustomColor(int alpha, int red, int green, int blue) {
        return new LColor(new Color(red, green, blue, alpha).getRGB());
    }

    public LImage getImage(LImageResource imageResource) throws Exception {
        return this.resourceAccess.getImage(imageResource);
    }

    public LLogger getLogger() {
        return this.logger;
    }

    public String getRawResourceAsString(LRawResource rawResource, int index) throws Exception {
        return this.resourceAccess.readRawResourceAsUTF8String(rawResource, index);
    }

    public String getRawResourceName(LRawResource rawResource, int index) throws Exception {
        return this.resourceAccess.getRawResourceName(rawResource, index);
    }

    public int getRawResourceNumberOfElements(LRawResource rawResource) throws Exception {
        return this.resourceAccess.getElementsPerResource(rawResource);
    }

    public LImage createImageFromColorMap(Map<LVector, LColor> colorsMap, LVector size, LColor defaultColor) {
        BufferedImage image = new BufferedImage((int)size.getX(), (int)size.getY(), 6);
        Graphics2D g = image.createGraphics();
        g.setColor(new Color(defaultColor.getAsInt()));
        g.fillRect(0, 0, (int)size.getX(), (int)size.getY());
        for (Map.Entry<LVector, LColor> i : colorsMap.entrySet()) {
            g.setColor(new Color(i.getValue().getAsInt()));
            LVector pos = i.getKey();
            g.drawRect((int)pos.getX(), (int)pos.getY(), 1, 1);
        }
        LImage result = new LImage();
        result.setHasAlpha(false);
        result.setImageObject((Object)image);
        result.setId("colorMapImage");
        result.setSize(size);
        return result;
    }

    public void setPresenter(LScreenPresenter presenter) {
        this.mainWindow.setPresenter(presenter);
    }

    private FSFFile getFile(LPlatform.StorageType directoryType, String relativePath, boolean createParentDir) throws Exception {
        File dataDir = new File("data");
        if (directoryType == LPlatform.StorageType.INTERNAL) {
            dataDir = new File(dataDir, "internal");
        } else if (directoryType == LPlatform.StorageType.EXTERNAL) {
            dataDir = new File(dataDir, "external");
        }
        String useRelativePath = relativePath.replace("\\", "/");
        if (useRelativePath.startsWith("/")) {
            useRelativePath = useRelativePath.substring(1);
        }
        FSFFile file = this.fsfSystem.createByPath(dataDir.getAbsolutePath() + "/" + useRelativePath);
        if (createParentDir) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public <K> K readObjectOrNull(LPlatform.StorageType directoryType, String relativePath, Class<K> classType) throws Exception {
        FSFFile file = this.getFile(directoryType, relativePath, true);
        if (!file.exists()) {
            return null;
        }
        return (K)file.readObject(classType);
    }

    public <K> void writeObject(LPlatform.StorageType directoryType, String relativePath, K object) throws Exception {
        this.getFile(directoryType, relativePath, true).writeObject(object);
    }

    public void writeStringToFile(LPlatform.StorageType directoryType, String relativePath, String string) throws Exception {
        try (BufferedOutputStream out = new BufferedOutputStream(this.getFile(directoryType, relativePath, true).getOutputStream(false));){
            out.write(string.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new Exception("Could not write file '" + relativePath + "'", e);
        }
    }

    public void deleteFile(LPlatform.StorageType directoryType, String relativePath) throws Exception {
        FSFFile file = this.getFile(directoryType, relativePath, false);
        if (file.exists()) {
            file.delete();
        }
    }

    public void getTextInput(String title, String message, String defaultValue, LTextInputResultListener listener) {
        Object result = JOptionPane.showInputDialog(this.mainWindow, message, title, -1, null, null, defaultValue);
        if (result == null) {
            listener.onTextInputResult(null);
        } else {
            listener.onTextInputResult(result.toString());
        }
    }

    public void showMessageDialog(String title, String message) {
        JOptionPane.showMessageDialog(this.mainWindow, message, title, -1);
    }

    public LFont getFont(LFontResource font) throws Exception {
        if (this.resourceAccess == null) {
            throw new Exception("resourceAccess not defined");
        }
        return this.resourceAccess.getFont(font);
    }

    public List<LAnimationFrame> getAnimationFrames(LAnimationResource animationResource) throws Exception {
        return this.resourceAccess.getAnimationFrames(animationResource);
    }

    public LConstants.InputMode getDefaultInputMode() {
        return LConstants.InputMode.SINGLE_POINTER;
    }

    public InputStream getInputStreamOrNull(LPlatform.StorageType directoryType, String relativePath) {
        try {
            FSFFile file = this.getFile(directoryType, relativePath, true);
            if (!file.exists()) {
                return null;
            }
            return file.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAbsolutePath(LPlatform.StorageType directoryType, String relativePath) {
        try {
            return this.getFile(directoryType, relativePath, true).getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void handleMissingResourceError(String message) {
        this.showMessageInMessageWindow(message);
    }

    private void showMessageInMessageWindow(String message) {
        this.messagesWindow.addText(message + "\n");
        this.messagesWindow.showWindow();
    }

    public void quit() {
        System.exit(0);
    }

    public Map<String, LImage> getIdToImageMap() throws Exception {
        return this.resourceAccess.getIdToImageMap();
    }

    public Map<String, LFont> getIdToFontMap() throws Exception {
        return this.resourceAccess.getIdToFontMap();
    }

    public boolean isExternalDirPermissionGranted() {
        return true;
    }

    public void showExternalDirPermissionRequest() {
        this.showMessageInMessageWindow("Not implemented: showExternalDirPermissionRequest()");
    }

    public String getStringOrNull(LPlatform.StorageType directoryType, String relativePath) {
        try {
            FSFFile file = this.getFile(directoryType, relativePath, true);
            this.logger.debug("file = '" + file.getAbsolutePath() + "'");
            if (!file.exists()) {
                return null;
            }
            return file.readString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void handleInternalError(Exception e) {
        if (e != null) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage() + "\nSee console/log for details");
        }
    }

    public boolean isBought(LBuyableItem item) {
        return false;
    }

    public void log(Object source, String message) {
        this.messagesWindow.addText("" + source + ":" + message + "\n");
        this.messagesWindow.showWindow();
    }

    public boolean readIsBoughtFromCache(LBuyableItem item) {
        return this.isBought(item);
    }

    public void buyItem(LBuyableItem item) {
        JOptionPane.showMessageDialog(null, "Buy level pack");
    }

    public void sendEMail(String eMailAddress) {
        JOptionPane.showMessageDialog(null, "Send e-mail");
    }

    public void addStatistics(Double fps, Double idleDuration, Double drawDuration, Double updateDuration, Integer levelID, String levelPos, Integer levelRemainingSeconds, String levelState) {
        this.instance.addStatistics(fps, idleDuration, drawDuration, updateDuration, levelID, levelPos, levelRemainingSeconds, levelState);
    }

    public void sendStatisticsIfNotBusy() {
        this.instance.sendStatisticsIfNotBusy();
    }

    public void statisticsSenderFinished(Exception exception) {
        this.instance.statisticsSenderFinished(exception);
    }

    public String getAppVersion() {
        return this.instance.getAppVersion();
    }

    public String getSystemType() {
        return this.instance.getSystemType();
    }
}

