/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.pc.base;

import de.bright_side.lgf.base.LLogger;

public class LPcLogger
implements LLogger {
    public void debug(String message) {
        LPcLogger.logAndGenerateLocation(LogLevel.DEBUG, message);
    }

    public void error(Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
        LPcLogger.logAndGenerateLocation(LogLevel.ERROR, "Error: " + t);
    }

    private static void logAndGenerateLocation(LogLevel logLevel, String message) {
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (ste.length < 3) {
            LPcLogger.log(logLevel, "?", "?", 0, message);
        } else {
            StackTraceElement e = ste[2];
            if (e != null) {
                String fileName = e.getFileName();
                String useFileName = null;
                if (fileName == null) {
                    useFileName = "" + ste[2];
                    int lastDotIndex = useFileName.lastIndexOf(".");
                    if (lastDotIndex >= 0) {
                        useFileName = useFileName.substring(0, lastDotIndex);
                    }
                } else {
                    useFileName = fileName.length() > 5 ? fileName.substring(0, fileName.length() - 5) : fileName;
                }
                LPcLogger.log(logLevel, useFileName, e.getMethodName(), e.getLineNumber(), message);
            } else {
                LPcLogger.log(logLevel, "???", "???", -1, message);
            }
        }
    }

    private static void log(LogLevel logLevel, String fileName, String methodName, int lineNumber, String message) {
        System.out.println((Object)((Object)logLevel) + ": " + fileName + "." + methodName + ":" + lineNumber + ">" + message);
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARNING,
        ERROR;

    }
}

