/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.pc.view;

import de.bright_side.lgf.base.LLogger;
import de.bright_side.lgf.model.LColor;
import de.bright_side.lgf.model.LFont;
import de.bright_side.lgf.model.LImage;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.pc.base.LPcUtil;
import de.bright_side.lgf.util.LMathsUtil;
import de.bright_side.lgf.view.LCanvas;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class LPcCanvas
implements LCanvas {
    private static final double FONT_TEXT_SIZE_FACTOR = 1.1;
    private LVector virtualSize;
    private LVector nativeCanvasSize;
    private Graphics2D graphics;
    private LVector scrollOffset;
    private final Font DEFAULT_FONT = new Font("sansserif", 0, 24);

    public LPcCanvas(LLogger logger, LVector virtualSize, Graphics2D graphics, LVector nativeCanvasSize, LVector cameraPos) {
        this.virtualSize = virtualSize;
        this.graphics = graphics;
        this.nativeCanvasSize = nativeCanvasSize;
        LVector halfScreenSize = LMathsUtil.multiply((LVector)virtualSize, (double)0.5);
        LVector cameraTopLeft = LMathsUtil.subtract((LVector)cameraPos, (LVector)halfScreenSize);
        this.scrollOffset = LMathsUtil.multiply((LVector)cameraTopLeft, (double)-1.0);
    }

    private LVector applyCameraPos(LVector pos, boolean considerCameraPos) {
        if (!considerCameraPos) {
            return pos;
        }
        return LMathsUtil.add((LVector)pos, (LVector)this.scrollOffset);
    }

    public void fillRect(LVector pos, LVector size, LColor color, boolean considerCameraPos) {
        LVector usePos = this.applyCameraPos(pos, considerCameraPos);
        this.graphics.setColor(new Color(color.getAsInt()));
        Rectangle rect = this.toRectInNativeCanvas(usePos, size);
        this.graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRectCentered(LVector pos, LVector size, LColor color, double opacity, boolean considerCameraPos) {
        if (opacity <= 0.0) {
            return;
        }
        LVector usePos = this.applyCameraPos(pos, considerCameraPos);
        Color useColor = this.applyOpacity(color, opacity);
        this.graphics.setColor(useColor);
        LVector centeredPos = LMathsUtil.add((LVector)usePos, (double)(-size.getX() / 2.0), (double)(-size.getY() / 2.0));
        Rectangle rect = this.toRectInNativeCanvas(centeredPos, size);
        this.graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    private Color applyOpacity(LColor color, double opacity) {
        Color useColor = new Color(color.getAsInt());
        if (opacity < 1.0) {
            useColor = new Color(useColor.getRed(), useColor.getGreen(), useColor.getBlue(), (int)((double)useColor.getAlpha() * opacity));
        }
        return useColor;
    }

    public void drawTextCentered(LVector pos, String text, double textSize, LColor color, LColor outlineColorOrNull, LFont fontOrNull, LVector shadowOffset, LColor shadowColor, double opacity, boolean considerCameraPos) {
        if (opacity <= 0.0) {
            return;
        }
        LVector usePos = this.applyCameraPos(pos, considerCameraPos);
        Font font = null;
        font = fontOrNull != null ? (Font)fontOrNull.getFontObject() : this.DEFAULT_FONT;
        this.graphics.setFont(font.deriveFont((float)(textSize * 1.1)));
        int width = this.graphics.getFontMetrics().stringWidth(text);
        LVector topLeft = this.toPointInNativeCanvas(usePos);
        topLeft = LMathsUtil.add((LVector)topLeft, (double)(-width / 2), (double)0.0);
        topLeft.setY(topLeft.getY() + (double)Math.abs(this.graphics.getFontMetrics().getAscent() / 2));
        if (shadowColor != null) {
            this.graphics.setColor(this.applyOpacity(shadowColor, opacity));
            LVector shadowOffsetInNativeCanvas = this.toPointInNativeCanvas(shadowOffset);
            this.graphics.drawString(text, (int)(topLeft.getX() + shadowOffsetInNativeCanvas.getX()), (int)(topLeft.getY() + shadowOffsetInNativeCanvas.getY()));
        }
        if (outlineColorOrNull != null) {
            this.graphics.setColor(this.applyOpacity(outlineColorOrNull, opacity));
            for (int textOffsetX = -1; textOffsetX <= 1; ++textOffsetX) {
                for (int textOffsetY = -1; textOffsetY <= 1; ++textOffsetY) {
                    if (textOffsetX == 0 && textOffsetY == 0) continue;
                    this.graphics.drawString(text, (int)topLeft.getX() + textOffsetX, (int)topLeft.getY() + textOffsetY);
                }
            }
        }
        if (color != null) {
            this.graphics.setColor(this.applyOpacity(color, opacity));
        } else {
            this.graphics.setColor(Color.BLACK);
        }
        this.graphics.drawString(text, (int)topLeft.getX(), (int)topLeft.getY());
    }

    private LVector toPointInNativeCanvas(LVector point) {
        LVector result = LMathsUtil.divide((LVector)point, (LVector)this.virtualSize);
        return LMathsUtil.multiply((LVector)result, (LVector)this.nativeCanvasSize);
    }

    private Rectangle toRectInNativeCanvas(LVector pos, LVector size) {
        LVector topLeft = this.toPointInNativeCanvas(pos);
        LVector adjustedSize = LMathsUtil.divide((LVector)size, (LVector)this.virtualSize);
        adjustedSize = LMathsUtil.multiply((LVector)adjustedSize, (LVector)this.nativeCanvasSize);
        LVector bottomRight = LMathsUtil.add((LVector)topLeft, (LVector)adjustedSize);
        return new Rectangle((int)topLeft.getX(), (int)topLeft.getY(), (int)bottomRight.getX() - (int)topLeft.getX(), (int)bottomRight.getY() - (int)topLeft.getY());
    }

    public void drawImageCentered(LVector pos, LVector size, LImage image, double rotation, double opacity, boolean considerCameraPos) {
        if (opacity <= 0.0) {
            return;
        }
        Composite originalComposite = null;
        if (opacity < 1.0) {
            originalComposite = this.graphics.getComposite();
            this.graphics.setComposite(AlphaComposite.getInstance(3, (float)opacity));
        }
        LVector usePos = this.applyCameraPos(pos, considerCameraPos);
        LVector useSize = this.toPointInNativeCanvas(size);
        LVector posInCanvas = this.toPointInNativeCanvas(usePos);
        BufferedImage bufferedImage = (BufferedImage)image.getImageObject();
        double imageOriginalWidth = bufferedImage.getWidth();
        double imageOriginalHeight = bufferedImage.getHeight();
        double scaleFactorX = useSize.getX() / imageOriginalWidth;
        double scaleFactorY = useSize.getY() / imageOriginalHeight;
        int drawLocationX = 0;
        int drawLocationY = 0;
        drawLocationX = (int)(posInCanvas.getX() - imageOriginalWidth * scaleFactorX / 2.0);
        drawLocationY = (int)(posInCanvas.getY() - imageOriginalHeight * scaleFactorY / 2.0);
        if (rotation == 0.0) {
            this.graphics.drawImage(bufferedImage, drawLocationX, drawLocationY, LPcUtil.cielInt(scaleFactorX * imageOriginalWidth), LPcUtil.cielInt(scaleFactorY * imageOriginalHeight), null);
            this.resetOpacity(originalComposite);
            return;
        }
        if (Math.abs(imageOriginalWidth - imageOriginalHeight) > 10.0) {
            bufferedImage = this.scaleImage(bufferedImage, (int)useSize.getX(), (int)useSize.getY());
            drawLocationX = (int)(posInCanvas.getX() - (double)bufferedImage.getWidth() * scaleFactorX / 2.0);
            drawLocationY = (int)(posInCanvas.getY() - (double)bufferedImage.getHeight() * scaleFactorY / 2.0);
            this.drawWithRotation(drawLocationX, drawLocationY, bufferedImage, rotation);
            this.resetOpacity(originalComposite);
            return;
        }
        double locationX = imageOriginalWidth * scaleFactorX / 2.0;
        double locationY = imageOriginalHeight * scaleFactorY / 2.0;
        double rotationRequired = Math.toRadians(rotation);
        AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
        tx.concatenate(AffineTransform.getScaleInstance(scaleFactorX, scaleFactorY));
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        this.graphics.drawImage((Image)op.filter(bufferedImage, null), drawLocationX, drawLocationY, null);
        this.resetOpacity(originalComposite);
    }

    private void resetOpacity(Composite originalComposite) {
        if (originalComposite != null) {
            this.graphics.setComposite(originalComposite);
        }
    }

    private BufferedImage scaleImage(BufferedImage original, int newWidth, int newHeight) {
        BufferedImage resized = new BufferedImage(newWidth, newHeight, 6);
        Graphics2D g = resized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(original, 0, 0, newWidth, newHeight, 0, 0, original.getWidth(), original.getHeight(), null);
        g.dispose();
        return resized;
    }

    private void drawWithRotation(int posX, int posY, BufferedImage bufferedImage, double rotation) {
        double locationX = bufferedImage.getWidth() / 2;
        double locationY = bufferedImage.getHeight() / 2;
        double diff = Math.abs(bufferedImage.getWidth() - bufferedImage.getHeight());
        double rotationRequired = Math.toRadians(rotation);
        double unitX = Math.abs(Math.cos(rotationRequired));
        double unitY = Math.abs(Math.sin(rotationRequired));
        double correctUx = unitX;
        double correctUy = unitY;
        if (bufferedImage.getWidth() < bufferedImage.getHeight()) {
            correctUx = unitY;
            correctUy = unitX;
        }
        int posAffineTransformOpX = posX - (int)locationX - (int)(correctUx * diff);
        int posAffineTransformOpY = posY - (int)locationY - (int)(correctUy * diff);
        AffineTransform objTrans = new AffineTransform();
        objTrans.translate(correctUx * diff, correctUy * diff);
        objTrans.rotate(rotationRequired, locationX, locationY);
        AffineTransformOp op = new AffineTransformOp(objTrans, 2);
        this.graphics.drawImage((Image)op.filter(bufferedImage, null), posAffineTransformOpX, posAffineTransformOpY, null);
    }

    private BufferedImage createSquaredBufferedImageToPreventRotationCutOff(BufferedImage originalImage, double originalWidth, double originalHeight) {
        if (originalWidth == originalHeight) {
            return originalImage;
        }
        int size = (int)Math.max(originalWidth, originalHeight);
        BufferedImage result = new BufferedImage(size, size, 6);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setColor(Color.RED);
        result.getGraphics().fillRect(0, 0, size, size);
        return result;
    }
}

