/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.pc.base;

import de.bright_side.lgf.base.LConstants;
import de.bright_side.lgf.logic.LVirtualSizeLogic;
import de.bright_side.lgf.model.LAnimationResource;
import de.bright_side.lgf.model.LFontResource;
import de.bright_side.lgf.model.LImageResource;
import de.bright_side.lgf.model.LRawResource;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.pc.base.LPcPlatform;
import de.bright_side.lgf.pc.base.LPcResourceAccess;
import de.bright_side.lgf.pc.base.LPcResourceDAO;
import de.bright_side.lgf.pc.base.PCResourceProperties;
import de.bright_side.lgf.pc.model.LPcAnimationResourceProperties;
import de.bright_side.lgf.pc.view.LPcMainWindow;
import de.bright_side.lgf.presenter.LScreenPresenter;
import de.bright_side.lgf.view.LScreenView;
import java.awt.Font;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public abstract class LPcInstance {
    private LPcMainWindow mainWindow;
    private LPcPlatform platform;
    private LPcResourceDAO resourceDAO;
    private LVector virtualSize;
    private LVector windowContentSize;
    private double scaleFactor;

    public LPcInstance(LPcResourceDAO resourceDAO, LVector windowContentSize, LVector prefVirtualSize, LConstants.ScaleMode scaleMode, double aspectRatio) {
        this.resourceDAO = resourceDAO;
        this.windowContentSize = windowContentSize;
        LVirtualSizeLogic virtualSizeLogic = new LVirtualSizeLogic();
        this.virtualSize = virtualSizeLogic.getVirtualSize(prefVirtualSize, windowContentSize, scaleMode, aspectRatio);
        this.scaleFactor = virtualSizeLogic.getVirtualSizeScaleFactor(prefVirtualSize, windowContentSize, scaleMode, aspectRatio);
    }

    public abstract void addStatistics(Double var1, Double var2, Double var3, Double var4, Integer var5, String var6, Integer var7, String var8);

    public abstract void sendStatisticsIfNotBusy();

    public abstract void statisticsSenderFinished(Exception var1);

    public abstract String getAppVersion();

    public abstract String getSystemType();

    public abstract LScreenPresenter createFirstScreenPresenter(LPcPlatform var1, LScreenView var2);

    public void run(boolean resume) {
        this.mainWindow = new LPcMainWindow(this, resume);
        this.platform = new LPcPlatform(this, this.mainWindow);
        LPcResourceAccess resourceAccess = new LPcResourceAccess(this);
        this.platform.init(resourceAccess);
        this.mainWindow.init(this.platform);
        this.mainWindow.setVisible(true);
    }

    public Map<LImageResource, String> createImageResourceMap() {
        return this.resourceDAO.createImageResourceMap();
    }

    public Map<LRawResource, List<PCResourceProperties>> createRawResourceMap() {
        return this.resourceDAO.createRawResourceMap();
    }

    public Map<LAnimationResource, LPcAnimationResourceProperties> createAnimationResourceMap() {
        return this.resourceDAO.createAnimationResourceMap();
    }

    public Map<LFontResource, Font> createFontResourceMap() {
        return this.resourceDAO.createFontResourceMap();
    }

    public InputStream getImageInputStream(String path) {
        return this.resourceDAO.getImageInputStream(path);
    }

    public InputStream getRawResourceInputStream(String path) {
        return this.resourceDAO.getRawResourceInputStream(path);
    }

    public LPcPlatform getPlatform() {
        return this.platform;
    }

    public abstract String getWindowTitle();

    public LVector getVirtualSize() {
        return this.virtualSize;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public LVector getWindowContentSize() {
        return this.windowContentSize;
    }
}

