/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.view;

import de.bright_side.lgf.base.LLogger;
import de.bright_side.lgf.base.LPlatform;
import de.bright_side.lgf.logic.LScreenLogic;
import de.bright_side.lgf.model.LObject;
import de.bright_side.lgf.model.LScreenModel;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.util.LMathsUtil;
import de.bright_side.lgf.view.LCanvas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LScreenView {
    private final LScreenLogic logic;
    private final LVector VECTOR_ONE = new LVector(1, 1);
    private final LVector VECTOR_ZERO = new LVector(0, 0);
    private final LLogger logger;
    private LScreenModel model;
    private LVector screenSize;
    private LVector cameraPos;
    private double fontScaleFactor;
    private Map<LObject, PosAndSize> panelObjectPosConsiderCamera = new HashMap<LObject, PosAndSize>();
    private Map<LObject, PosAndSize> panelObjectPosIgnoreCamera = new HashMap<LObject, PosAndSize>();
    private Map<LObject, PosAndSize> panelObjectPosConsiderCameraInProgress;
    private Map<LObject, PosAndSize> panelObjectPosIgnoreCameraInProgress;

    public LScreenView(LPlatform platform, LVector screenSize, double fontScaleFactor) {
        this.screenSize = screenSize;
        this.fontScaleFactor = fontScaleFactor;
        this.logger = platform.getLogger();
        this.cameraPos = LMathsUtil.multiply(screenSize, 0.5);
        this.logic = new LScreenLogic();
    }

    public void draw(LCanvas canvas) {
        boolean log = false;
        this.panelObjectPosConsiderCameraInProgress = new HashMap<LObject, PosAndSize>();
        this.panelObjectPosIgnoreCameraInProgress = new HashMap<LObject, PosAndSize>();
        if (this.model.getBackgroundColor() != null) {
            canvas.fillRect(new LVector(0, 0), this.screenSize, this.model.getBackgroundColor(), false);
        }
        for (LObject i : this.logic.getAllObjects(this.model, false)) {
            this.drawWithPanelItems(canvas, i, true, log, null);
        }
        if (this.model.getUiObjects() != null) {
            for (LObject i : this.model.getUiObjects()) {
                if (log) {
                    this.logger.debug("drawing ui object: " + i);
                }
                this.drawWithPanelItems(canvas, i, false, log, null);
            }
        }
        this.panelObjectPosConsiderCamera = this.panelObjectPosConsiderCameraInProgress;
        this.panelObjectPosIgnoreCamera = this.panelObjectPosIgnoreCameraInProgress;
    }

    private void drawWithPanelItems(LCanvas canvas, LObject object, boolean considerCameraPos, boolean log, PanelDrawParams drawParams) {
        this.draw(canvas, object, considerCameraPos, log, drawParams);
        if (object.getPanelObjects() == null) {
            return;
        }
        PanelDrawParams parentDrawParams = drawParams;
        if (parentDrawParams == null) {
            parentDrawParams = new PanelDrawParams();
            parentDrawParams.sizeFactor = this.VECTOR_ONE;
            parentDrawParams.offset = this.VECTOR_ZERO;
            parentDrawParams.opacityFactor = 1.0;
            parentDrawParams.fontSizeFactor = 1.0;
        }
        PanelDrawParams childDrawParams = new PanelDrawParams();
        LVector panelSize = object.getPanelSize();
        if (panelSize == null) {
            panelSize = object.getSize();
            childDrawParams.sizeFactor = parentDrawParams.sizeFactor;
        } else {
            childDrawParams.sizeFactor = new LVector(parentDrawParams.sizeFactor.x * object.getSize().x / panelSize.x, parentDrawParams.sizeFactor.y * object.getSize().y / panelSize.y);
        }
        childDrawParams.fontSizeFactor = Math.min(childDrawParams.sizeFactor.x, childDrawParams.sizeFactor.y);
        childDrawParams.offset = new LVector(parentDrawParams.offset.x + object.getPos().x - object.getSize().x / 2.0, parentDrawParams.offset.y + object.getPos().y - object.getSize().y / 2.0);
        childDrawParams.opacityFactor = parentDrawParams.opacityFactor * object.getOpacity();
        for (LObject i : object.getPanelObjects()) {
            this.drawWithPanelItems(canvas, i, considerCameraPos, log, childDrawParams);
        }
    }

    private void draw(LCanvas canvas, LObject object, boolean considerCameraPos, boolean log, PanelDrawParams panelDrawParam) {
        if (!object.isVisible()) {
            return;
        }
        if (object.getBlinkingInterval() != null && object.getBlinkingInterval() != 0L) {
            long interval = object.getBlinkingInterval();
            if (System.currentTimeMillis() % (interval * 2L) > interval) {
                return;
            }
        }
        LVector usePos = null;
        LVector useSize = null;
        double useOpacity = 0.0;
        double useFontSizeFactor = 0.0;
        if (panelDrawParam == null) {
            usePos = object.getPos();
            useSize = object.getSize();
            useOpacity = object.getOpacity();
            useFontSizeFactor = 1.0;
        } else {
            usePos = new LVector(panelDrawParam.offset.x + object.getPos().x * panelDrawParam.sizeFactor.x, panelDrawParam.offset.y + object.getPos().y * panelDrawParam.sizeFactor.y);
            useSize = new LVector(object.getSize().x * panelDrawParam.sizeFactor.x, object.getSize().y * panelDrawParam.sizeFactor.y);
            useOpacity = panelDrawParam.opacityFactor * object.getOpacity();
            useFontSizeFactor = panelDrawParam.fontSizeFactor;
        }
        if (object.getBackgroundColor() != null) {
            canvas.fillRectCentered(usePos, useSize, object.getBackgroundColor(), useOpacity, considerCameraPos);
        }
        if (object.getImage() != null) {
            canvas.drawImageCentered(usePos, useSize, object.getImage(), object.getRotation(), useOpacity, considerCameraPos);
        }
        if (object.getText() != null && !object.getText().isEmpty()) {
            canvas.drawTextCentered(usePos, object.getText(), object.getTextSize() / this.fontScaleFactor / 2.0 * useFontSizeFactor, object.getTextColor(), object.getTextOutlineColor(), object.getTextFont(), object.getTextShadowOffset(), object.getTextShadowColor(), useOpacity, considerCameraPos);
        }
        if (object.isTouchable() && object.isVisible()) {
            PosAndSize posAndSize = new PosAndSize();
            posAndSize.pos = usePos;
            posAndSize.size = useSize;
            if (considerCameraPos) {
                this.panelObjectPosConsiderCameraInProgress.put(object, posAndSize);
            } else {
                this.panelObjectPosIgnoreCameraInProgress.put(object, posAndSize);
            }
        }
    }

    public void setModel(LScreenModel model) {
        this.model = model;
    }

    public List<LObject> getTouchedObjects(LVector pos, LVector posIgnoreCamera) {
        PosAndSize posAndSize;
        ArrayList<LObject> result = new ArrayList<LObject>();
        for (LObject lObject : this.logic.getAllObjects(this.model, false)) {
            if (!lObject.isVisible() || !lObject.isTouchable() || !LMathsUtil.isInCenteredArea(pos, lObject.getPos(), lObject.getSize())) continue;
            result.add(lObject);
        }
        if (this.model.getUiObjects() != null) {
            for (LObject lObject : this.model.getUiObjects()) {
                if (!lObject.isVisible() || !lObject.isTouchable() || !LMathsUtil.isInCenteredArea(posIgnoreCamera, lObject.getPos(), lObject.getSize())) continue;
                result.add(lObject);
            }
        }
        for (Map.Entry entry : this.panelObjectPosConsiderCamera.entrySet()) {
            posAndSize = (PosAndSize)entry.getValue();
            if (!LMathsUtil.isInCenteredArea(pos, posAndSize.pos, posAndSize.size)) continue;
            result.add((LObject)entry.getKey());
        }
        for (Map.Entry entry : this.panelObjectPosIgnoreCamera.entrySet()) {
            posAndSize = (PosAndSize)entry.getValue();
            if (!LMathsUtil.isInCenteredArea(posIgnoreCamera, posAndSize.pos, posAndSize.size)) continue;
            result.add((LObject)entry.getKey());
        }
        return result;
    }

    public LVector getCameraPos() {
        return this.cameraPos;
    }

    public void setCameraPos(LVector cameraPos) {
        this.cameraPos = cameraPos;
    }

    public LVector getScreenSize() {
        return this.screenSize;
    }

    public void cameraPosToCenter() {
        this.cameraPos = LMathsUtil.divide(this.screenSize, 2.0);
    }

    private class PosAndSize {
        public LVector pos;
        public LVector size;

        private PosAndSize() {
        }
    }

    private class PanelDrawParams {
        public LVector offset;
        public LVector sizeFactor;
        public double fontSizeFactor;
        public double opacityFactor;

        private PanelDrawParams() {
        }

        public String toString() {
            return "PanelDrawParams [offset=" + this.offset + ", sizeFactor=" + this.sizeFactor + ", fontSizeFactor=" + this.fontSizeFactor + ", opacityFactor=" + this.opacityFactor + "]";
        }
    }
}

