/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.util;

import de.bright_side.lgf.model.LAnimationFrame;
import de.bright_side.lgf.model.LFont;
import de.bright_side.lgf.model.LImage;
import de.bright_side.lgf.model.LObject;
import de.bright_side.lgf.util.LErrorListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LUtil {
    public static void callTouchedActions(List<LObject> touchedObjects, LErrorListener errorListener) {
        if (touchedObjects == null) {
            return;
        }
        for (LObject i : touchedObjects) {
            if (i.getTouchAction() == null) continue;
            try {
                i.getTouchAction().onAction();
            }
            catch (Throwable t) {
                if (errorListener == null) continue;
                errorListener.onError(t);
            }
        }
    }

    private static void log(String message) {
        System.out.println("LUtil> " + message);
    }

    public static List<LObject> copyWithoutResourceReferences(List<LObject> objects) {
        ArrayList<LObject> result = new ArrayList<LObject>();
        for (LObject i : objects) {
            result.add(LUtil.copyWithoutResourceReferences(i));
        }
        return result;
    }

    public static void setResourceReferences(List<LObject> objects, Map<String, LImage> images, Map<String, LFont> fonts) throws Exception {
        for (LObject i : objects) {
            LUtil.setResourceReferences(i, images, fonts);
        }
    }

    private static List<LAnimationFrame> copyAnimationListWithoutResourceReferences(List<LAnimationFrame> animationFrames) {
        if (animationFrames == null) {
            return null;
        }
        ArrayList<LAnimationFrame> result = new ArrayList<LAnimationFrame>();
        for (LAnimationFrame i : animationFrames) {
            result.add(new LAnimationFrame(LUtil.copyWithoutResourceReferences(i.getImage()), i.getDurationInSeconds()));
        }
        return result;
    }

    private static LFont copyWithoutResourceReferences(LFont textFont) {
        if (textFont == null) {
            return null;
        }
        LFont result = new LFont();
        result.setId(textFont.getId());
        return result;
    }

    private static LImage copyWithoutResourceReferences(LImage image) {
        if (image == null) {
            return null;
        }
        LImage result = new LImage();
        result.setId(image.getId());
        result.setHasAlpha(image.isHasAlpha());
        return result;
    }

    public static LObject copyWithoutResourceReferences(LObject object) {
        LObject result = new LObject();
        result.setType(object.getType());
        result.setId(object.getId());
        result.setPos(object.getPos());
        result.setImage(LUtil.copyWithoutResourceReferences(object.getImage()));
        result.setBackgroundColor(object.getBackgroundColor());
        result.setSize(object.getSize());
        result.setText(object.getText());
        result.setSpeed(object.getSpeed());
        result.setRotation(object.getRotation());
        result.setCollisionPolygon(object.getCollisionPolygon());
        result.setVisible(object.isVisible());
        result.setBlinkingInterval(object.getBlinkingInterval());
        result.setTextFont(LUtil.copyWithoutResourceReferences(object.getTextFont()));
        result.setTextColor(object.getTextColor());
        result.setTextOutlineColor(object.getTextOutlineColor());
        result.setTextShadowColor(object.getTextShadowColor());
        result.setTextShadowOffset(object.getTextShadowOffset());
        result.setTextSize(object.getTextSize());
        result.setPath(object.getPath());
        result.setNextPathItem(object.getNextPathItem());
        result.setMaximumRotationPerSecond(object.getMaximumRotationPerSecond());
        result.setAnimationFrames(LUtil.copyAnimationListWithoutResourceReferences(object.getAnimationFrames()));
        result.setAnimationFrameIndex(object.getAnimationFrameIndex());
        result.setRemainingSecondsInAnimationFrame(object.getRemainingSecondsInAnimationFrame());
        result.setTouchable(object.isTouchable());
        result.setTouchAction(object.getTouchAction());
        result.setOpacity(object.getOpacity());
        result.setPanelSize(object.getPanelSize());
        if (object.getPanelObjects() != null) {
            ArrayList<LObject> panelObjects = new ArrayList<LObject>();
            for (LObject i : object.getPanelObjects()) {
                panelObjects.add(LUtil.copyWithoutResourceReferences(i));
            }
            object.setPanelObjects(panelObjects);
        }
        return result;
    }

    public static void setResourceReferences(LObject object, Map<String, LImage> images, Map<String, LFont> fonts) throws Exception {
        if (object.getImage() != null) {
            LImage imageObject = images.get(object.getImage().getId());
            if (imageObject == null) {
                throw new Exception("Unkonwn image with id '" + object.getImage().getId() + "'. Known ids: " + images.keySet());
            }
            object.getImage().setImageObject(imageObject.getImageObject());
        }
        if (object.getTextFont() != null) {
            LFont fontObject = fonts.get(object.getTextFont().getId());
            if (fontObject == null) {
                throw new Exception("Unkonwn font with id '" + object.getTextFont().getId());
            }
            object.getTextFont().setFontObject(fontObject.getFontObject());
        }
        if (object.getAnimationFrames() != null) {
            for (LAnimationFrame frame : object.getAnimationFrames()) {
                LImage image;
                if (frame == null || (image = frame.getImage()) == null) continue;
                LImage imageObject = images.get(image.getId());
                if (imageObject == null) {
                    throw new Exception("Unkonwn image with id '" + image.getId());
                }
                image.setImageObject(imageObject.getImageObject());
            }
        }
    }
}

