/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.logic;

import de.bright_side.lgf.model.LAction;
import de.bright_side.lgf.model.LObject;
import de.bright_side.lgf.model.LTween;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.util.LMathsUtil;
import java.util.ArrayList;
import java.util.List;

public class LTweenLogic {
    private List<LTween> getTweens(LObject object) {
        List<LTween> tweens = object.getTweens();
        if (tweens == null) {
            tweens = new ArrayList<LTween>();
        }
        return tweens;
    }

    public void setMoveTween(LTween tween, LVector startPos, LVector destPos, double durationInSeconds) {
        LVector posChange = LMathsUtil.subtract(destPos, startPos);
        posChange = LMathsUtil.divide(posChange, durationInSeconds);
        tween.setDurationInSeconds(durationInSeconds);
        tween.setPosChange(posChange);
    }

    public void addMoveTween(LObject object, LVector destPos, double durationInSeconds) {
        LTween tween = new LTween();
        LVector startPos = this.getPosAfterAllTweens(object);
        this.setMoveTween(tween, startPos, destPos, durationInSeconds);
        this.addTween(object, tween);
    }

    public LVector getPosAfterAllTweens(LObject object) {
        LVector result = object.getPos();
        List<LTween> tweens = object.getTweens();
        if (tweens == null) {
            return result;
        }
        for (LTween i : tweens) {
            if (i.getPosChange() == null) continue;
            result = LMathsUtil.add(result, LMathsUtil.multiply(i.getPosChange(), i.getDurationInSeconds()));
        }
        return result;
    }

    public LVector getSizeAfterAllTweens(LObject object) {
        LVector result = object.getSize();
        List<LTween> tweens = object.getTweens();
        if (tweens == null) {
            return result;
        }
        for (LTween i : tweens) {
            if (i.getSizeChange() == null) continue;
            result = LMathsUtil.add(result, LMathsUtil.multiply(i.getSizeChange(), i.getDurationInSeconds()));
        }
        return result;
    }

    public void setSizeTween(LTween tween, LVector startSize, LVector destSize, double durationInSeconds) {
        LVector sizeChange = LMathsUtil.subtract(destSize, startSize);
        sizeChange = LMathsUtil.divide(sizeChange, durationInSeconds);
        tween.setDurationInSeconds(durationInSeconds);
        tween.setSizeChange(sizeChange);
    }

    public void addSizeTween(LObject object, LVector destSize, double durationInSeconds) {
        LTween tween = new LTween();
        this.setSizeTween(tween, this.getSizeAfterAllTweens(object), destSize, durationInSeconds);
        this.addTween(object, tween);
    }

    public double getOpacityAfterAllTweens(LObject object) {
        double result = object.getOpacity();
        List<LTween> tweens = object.getTweens();
        if (tweens == null) {
            return result;
        }
        for (LTween i : tweens) {
            result += i.getOpacityChange();
        }
        return result;
    }

    public void setOpacityTween(LTween tween, double startValue, double destValue, double durationInSeconds) {
        double change = (destValue - startValue) / durationInSeconds;
        tween.setDurationInSeconds(durationInSeconds);
        tween.setOpacityChange(change);
    }

    public void addOpacityTween(LObject object, double destValue, double durationInSeconds) {
        LTween tween = new LTween();
        this.setOpacityTween(tween, this.getOpacityAfterAllTweens(object), destValue, durationInSeconds);
        this.addTween(object, tween);
    }

    public void setTextSizeTween(LTween tween, LObject object, double destSize, double durationInSeconds) {
        double sizeChange = destSize - object.getTextSize();
        tween.setDurationInSeconds(durationInSeconds);
        tween.setTextSizeChange(sizeChange /= durationInSeconds);
    }

    public void addTextSizeTween(LObject object, double destSize, double durationInSeconds) {
        LTween tween = new LTween();
        this.setTextSizeTween(tween, object, destSize, durationInSeconds);
        this.addTween(object, tween);
    }

    public void setRotationTween(LTween tween, LObject object, double destRotation, boolean clockwise, double durationInSeconds) {
        double useDestRotation = destRotation;
        if (useDestRotation < 0.0) {
            useDestRotation = 0.0;
        } else if (useDestRotation > 360.0) {
            useDestRotation = 360.0;
        }
        double rotationChange = useDestRotation - object.getRotation();
        if (!clockwise) {
            if (rotationChange < 0.0) {
                rotationChange += 360.0;
            } else if (rotationChange > 0.0) {
                rotationChange -= 360.0;
            }
        }
        tween.setRotationChange(rotationChange /= durationInSeconds);
        tween.setDurationInSeconds(durationInSeconds);
    }

    public void addRotationTween(LObject object, double destRotation, boolean clockwise, double durationInSeconds) {
        LTween tween = new LTween();
        this.setRotationTween(tween, object, destRotation, clockwise, durationInSeconds);
        this.addTween(object, tween);
    }

    public void addTween(LObject object, LTween tween) {
        List<LTween> tweens = this.getTweens(object);
        tweens.add(tween);
        object.setTweens(tweens);
    }

    public void updateTweens(List<LObject> objects, double secondsSinceLastUpdate) {
        for (LObject i : objects) {
            this.updateTweens(i, secondsSinceLastUpdate);
        }
    }

    public boolean updateTweens(LObject object, double secondsSinceLastUpdate) {
        double tweenDuration;
        List<LTween> tweens = object.getTweens();
        if (tweens == null) {
            return false;
        }
        if (tweens.isEmpty()) {
            object.setTweens(null);
            return false;
        }
        for (double restSeconds = secondsSinceLastUpdate; restSeconds > 0.0; restSeconds -= tweenDuration) {
            LTween tween = tweens.get(0);
            tweenDuration = tween.getDurationInSeconds();
            if (tweenDuration > restSeconds) {
                tween.setDurationInSeconds(tweenDuration - restSeconds);
                this.performTween(object, tween, restSeconds);
                return false;
            }
            this.performTween(object, tween, tweenDuration);
            this.performTweenAction(object, tween);
            tweens.remove(0);
            if (!tweens.isEmpty()) continue;
            object.setTweens(null);
            return true;
        }
        return false;
    }

    private void performTweenAction(LObject object, LTween tween) {
        LAction completionAction = tween.getCompletionAction();
        if (completionAction != null) {
            completionAction.onAction();
        }
    }

    private void performTween(LObject object, LTween tween, double seconds) {
        if (tween.getPosChange() != null) {
            LVector posChange = LMathsUtil.multiply(tween.getPosChange(), seconds);
            object.setPos(LMathsUtil.add(object.getPos(), posChange));
        }
        if (tween.getSizeChange() != null) {
            LVector sizeChange = LMathsUtil.multiply(tween.getSizeChange(), seconds);
            object.setSize(LMathsUtil.add(object.getSize(), sizeChange));
        }
        if (tween.getRotationChange() != 0.0) {
            double rotationChange = tween.getRotationChange() * seconds;
            object.setRotation(LMathsUtil.rotate(object.getRotation(), rotationChange));
        }
        if (tween.getTextSizeChange() != 0.0) {
            double textSizeChange = tween.getTextSizeChange() * seconds;
            object.setTextSize(object.getTextSize() + textSizeChange);
        }
        if (tween.getOpacityChange() != 0.0) {
            double opacityChange = tween.getOpacityChange() * seconds;
            object.setOpacity(object.getOpacity() + opacityChange);
        }
    }
}

