/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.logic;

import de.bright_side.lgf.model.LAnimationFrame;
import de.bright_side.lgf.model.LColor;
import de.bright_side.lgf.model.LFont;
import de.bright_side.lgf.model.LObject;
import de.bright_side.lgf.model.LPolygon;
import de.bright_side.lgf.model.LScreenModel;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.util.LMathsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class LScreenLogic {
    private static final double MAX_DEGREES = 360.0;

    public LPolygon createCollisionPolygon(LObject object) {
        LPolygon polygon = object.getCollisionPolygon();
        if (polygon == null) {
            polygon = this.createRectanglePolygon();
        }
        LPolygon result = this.adjustPolygonToPosRotationAndSize(object, polygon);
        return result;
    }

    private LPolygon adjustPolygonToPosRotationAndSize(LObject object, LPolygon polygon) {
        LPolygon result = LMathsUtil.multiply(polygon, object.getSize());
        LVector negativeHalfSize = LMathsUtil.multiply(object.getSize(), -0.5);
        result = LMathsUtil.add(result, object.getPos());
        result = LMathsUtil.add(result, negativeHalfSize);
        if (object.getRotation() != 0.0) {
            result = LMathsUtil.rotate(result, object.getPos(), object.getRotation());
        }
        return result;
    }

    private LPolygon createRectanglePolygon() {
        LPolygon result = new LPolygon();
        ArrayList<LVector> resultPoints = new ArrayList<LVector>();
        result.setPoints(resultPoints);
        resultPoints.add(new LVector(0, 0));
        resultPoints.add(new LVector(1, 0));
        resultPoints.add(new LVector(1, 1));
        resultPoints.add(new LVector(0, 1));
        resultPoints.add(new LVector(0, 0));
        return result;
    }

    public List<LObject> getAllObjects(LScreenModel model, boolean includeUIObjects) {
        ArrayList<LObject> result = new ArrayList<LObject>();
        if (model.getBackgroundObjects() != null) {
            result.addAll(model.getBackgroundObjects());
        }
        if (model.getEnemyObjects() != null) {
            result.addAll(model.getEnemyObjects());
        }
        if (model.getPlayerObjects() != null) {
            result.addAll(model.getPlayerObjects());
        }
        if (model.getForegroundObjects() != null) {
            result.addAll(model.getForegroundObjects());
        }
        if (includeUIObjects && model.getUiObjects() != null) {
            result.addAll(model.getUiObjects());
        }
        return result;
    }

    public List<LObject> getAllObjectsExcludeEnemies(LScreenModel model) {
        ArrayList<LObject> result = new ArrayList<LObject>();
        if (model.getBackgroundObjects() != null) {
            result.addAll(model.getBackgroundObjects());
        }
        if (model.getPlayerObjects() != null) {
            result.addAll(model.getPlayerObjects());
        }
        if (model.getBackgroundObjects() != null) {
            result.addAll(model.getForegroundObjects());
        }
        return result;
    }

    public List<LObject> getAllCollidingObjects(LObject objectA, LObject ... listOfObjects) {
        return this.getAllCollidingObjects(objectA, Arrays.asList(listOfObjects));
    }

    public boolean isColliding(LObject objectA, LObject ... listOfObjects) {
        return !this.getAllCollidingObjects(objectA, Arrays.asList(listOfObjects)).isEmpty();
    }

    public List<LObject> getAllCollidingObjects(LObject objectA, List<LObject> listOfObjects) {
        ArrayList<LObject> result = new ArrayList<LObject>();
        if (objectA == null) {
            return result;
        }
        boolean optimize = true;
        boolean tooFarAway = false;
        double objectARadius = 0.0;
        if (optimize) {
            objectARadius = Math.max(objectA.getSize().getX(), objectA.getSize().getY());
        }
        LPolygon objectACollisionPolygon = null;
        for (LObject i : listOfObjects) {
            LPolygon enemyCollisionPolygon;
            if (!i.isVisible()) continue;
            double objectBRadius = 0.0;
            if (optimize) {
                objectBRadius = Math.max(i.getSize().getX(), i.getSize().getY());
                double maxDistance = objectARadius + objectBRadius;
                double objectAPosX = objectA.getPos().getX();
                double objectAPosY = objectA.getPos().getY();
                double objectBPosX = i.getPos().getX();
                double objectBPosY = i.getPos().getY();
                if (Math.abs(objectAPosX - objectBPosX) > maxDistance || Math.abs(objectAPosY - objectBPosY) > maxDistance) {
                    tooFarAway = true;
                } else {
                    boolean bl = tooFarAway = LMathsUtil.getDistance(objectA.getPos(), i.getPos()) > maxDistance;
                }
            }
            if (tooFarAway) continue;
            if (objectACollisionPolygon == null) {
                objectACollisionPolygon = this.createCollisionPolygon(objectA);
            }
            if (!LMathsUtil.isIntersecting(objectACollisionPolygon, enemyCollisionPolygon = this.createCollisionPolygon(i))) continue;
            result.add(i);
        }
        return result;
    }

    protected double getNeededRotationClosedToCurrentRotationAndOutOfRange(LObject object, LVector dest) {
        double neededRotation = LMathsUtil.getAngleInDegrees(object.getPos(), dest);
        if (Math.abs(neededRotation + 360.0 - object.getRotation()) < Math.abs(neededRotation - object.getRotation())) {
            neededRotation += 360.0;
        } else if (Math.abs(neededRotation - 360.0 - object.getRotation()) < Math.abs(neededRotation - object.getRotation())) {
            neededRotation -= 360.0;
        }
        return neededRotation;
    }

    public void updateObjectToFollowPath(LObject object, double distanceToConsiderPathPointReached, double maximumSteerRotation) {
        List<LVector> path = object.getPath();
        if (path == null) {
            return;
        }
        LVector nextPos = path.get(object.getNextPathItem());
        if (LMathsUtil.getDistance(object.getPos(), nextPos) <= distanceToConsiderPathPointReached) {
            object.setNextPathItem(object.getNextPathItem() + 1);
            if (object.getNextPathItem() >= object.getPath().size()) {
                object.setNextPathItem(0);
            }
            nextPos = path.get(object.getNextPathItem());
        }
        double neededRotation = this.getNeededRotationClosedToCurrentRotationAndOutOfRange(object, nextPos);
        double newRotation = object.getRotation();
        newRotation = Math.abs(neededRotation - object.getRotation()) <= maximumSteerRotation ? neededRotation : (object.getRotation() < neededRotation ? (newRotation += maximumSteerRotation) : (newRotation -= maximumSteerRotation));
        object.setRotation(LMathsUtil.rotate(newRotation, 0.0));
    }

    public void animate(Collection<LObject> objects, double secondsSinceLastUpdate) {
        for (LObject i : objects) {
            this.animate(i, secondsSinceLastUpdate);
        }
    }

    public void animate(LObject object, double secondsSinceLastUpdate) {
        List<LAnimationFrame> animationFrames;
        if (object.getAnimationFrames() == null) {
            return;
        }
        double remainingTime = object.getRemainingSecondsInAnimationFrame() - secondsSinceLastUpdate;
        if (remainingTime > 0.0) {
            object.setRemainingSecondsInAnimationFrame(remainingTime);
            return;
        }
        int nextFrameIndex = object.getAnimationFrameIndex() + 1;
        if (nextFrameIndex >= (animationFrames = object.getAnimationFrames()).size()) {
            nextFrameIndex = 0;
        }
        object.setAnimationFrameIndex(nextFrameIndex);
        LAnimationFrame animationFrame = animationFrames.get(nextFrameIndex);
        if (animationFrame == null) {
            return;
        }
        double remainingSecondsInAnimationFrame = remainingTime + animationFrame.getDurationInSeconds();
        object.setRemainingSecondsInAnimationFrame(remainingSecondsInAnimationFrame);
        object.setImage(animationFrame.getImage());
    }

    public LObject createObject(LVector size, LVector pos) {
        LObject result = new LObject();
        result.setVisible(true);
        result.setSize(size);
        result.setPos(pos);
        return result;
    }

    public LObject setText(LObject object, String text, LFont textFont, double textSize, LColor textColor) {
        object.setText(text);
        object.setTextColor(textColor);
        object.setTextSize(textSize);
        object.setTextFont(textFont);
        return object;
    }

    public LObject setTextShadow(LObject object, LVector shadowOffset, LColor shadowColor) {
        object.setTextShadowOffset(shadowOffset);
        object.setTextShadowColor(shadowColor);
        return object;
    }

    public LObject setAnimation(LObject result, List<LAnimationFrame> animationFrames) {
        result.setAnimationFrames(animationFrames);
        int frameIndex = (int)(Math.random() * (double)animationFrames.size());
        result.setAnimationFrameIndex(frameIndex);
        result.setRemainingSecondsInAnimationFrame(Math.random() * animationFrames.get(frameIndex).getDurationInSeconds());
        result.setImage(animationFrames.get(frameIndex).getImage());
        return result;
    }
}

