/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.lgf.base;

import de.bright_side.lgf.base.LConstants;
import de.bright_side.lgf.base.LLogger;
import de.bright_side.lgf.base.LTextInputResultListener;
import de.bright_side.lgf.model.LAnimationFrame;
import de.bright_side.lgf.model.LAnimationResource;
import de.bright_side.lgf.model.LBuyableItem;
import de.bright_side.lgf.model.LColor;
import de.bright_side.lgf.model.LFont;
import de.bright_side.lgf.model.LFontResource;
import de.bright_side.lgf.model.LImage;
import de.bright_side.lgf.model.LImageResource;
import de.bright_side.lgf.model.LRawResource;
import de.bright_side.lgf.model.LVector;
import de.bright_side.lgf.presenter.LScreenPresenter;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public interface LPlatform {
    public void log(Object var1, String var2);

    public void buyItem(LBuyableItem var1);

    public boolean isBought(LBuyableItem var1);

    public boolean readIsBoughtFromCache(LBuyableItem var1);

    public LColor getColorRed();

    public LColor getColorYellow();

    public LColor getColorBlue();

    public LColor getColorGreen();

    public LColor getColorGray();

    public LColor getColorBlack();

    public LColor getColorWhite();

    public LColor getCustomColor(int var1, int var2, int var3);

    public LColor getCustomColor(int var1, int var2, int var3, int var4);

    public LImage getImage(LImageResource var1) throws Exception;

    public List<LAnimationFrame> getAnimationFrames(LAnimationResource var1) throws Exception;

    public LFont getFont(LFontResource var1) throws Exception;

    public String getRawResourceAsString(LRawResource var1, int var2) throws Exception;

    public int getRawResourceNumberOfElements(LRawResource var1) throws Exception;

    public String getRawResourceName(LRawResource var1, int var2) throws Exception;

    public LLogger getLogger();

    public void setPresenter(LScreenPresenter var1);

    public LImage createImageFromColorMap(Map<LVector, LColor> var1, LVector var2, LColor var3);

    public <K> K readObjectOrNull(StorageType var1, String var2, Class<K> var3) throws Exception;

    public <K> void writeObject(StorageType var1, String var2, K var3) throws Exception;

    public void writeStringToFile(StorageType var1, String var2, String var3) throws Exception;

    public void deleteFile(StorageType var1, String var2) throws Exception;

    public InputStream getInputStreamOrNull(StorageType var1, String var2);

    public void getTextInput(String var1, String var2, String var3, LTextInputResultListener var4);

    public void showMessageDialog(String var1, String var2);

    public LConstants.InputMode getDefaultInputMode();

    public String getStringOrNull(StorageType var1, String var2);

    public String getAbsolutePath(StorageType var1, String var2);

    public void handleMissingResourceError(String var1);

    public void quit();

    public Map<String, LImage> getIdToImageMap() throws Exception;

    public Map<String, LFont> getIdToFontMap() throws Exception;

    public boolean isExternalDirPermissionGranted();

    public void showExternalDirPermissionRequest();

    public void addStatistics(Double var1, Double var2, Double var3, Double var4, Integer var5, String var6, Integer var7, String var8);

    public void sendStatisticsIfNotBusy();

    public void statisticsSenderFinished(Exception var1);

    public String getAppVersion();

    public String getSystemType();

    public void handleInternalError(Exception var1);

    public void sendEMail(String var1);

    public static enum StorageType {
        INTERNAL,
        EXTERNAL;

    }
}

