/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.bdbexport.bl;

import de.bright_side.bdbexport.bl.DbUtil;
import java.sql.Connection;
import java.util.List;

public class DbSqliteUtil {
    public static final String SM_TYPE_TABLE = "table";
    public static final String SM_TYPE_VIEW = "view";
    public static final String SM_TYPE_INDEX = "index";
    private static final String SQLITE_MASTER = "sqlite_master";
    private static final String SM_SQL_COLUMN = "sql";
    private static final String SM_TABLE_TYPE_COLUMN = "type";
    private static final String SM_TABLENAME_COLUMN = "tbl_name";

    public static String readSqliteDdlForObject(Connection connection, String objectType, String objectName) throws Exception {
        String sql = "SELECT sql FROM sqlite_master WHERE type = ? AND tbl_name = ?";
        return DbSqliteUtil.ensureTrainingSemicolon(DbUtil.getStringQueryResult(connection, sql, objectType, objectName));
    }

    public static String readSqliteIndexDdlsForTable(Connection connection, String objectName) throws Exception {
        StringBuilder result = new StringBuilder();
        String sql = "SELECT sql FROM sqlite_master WHERE type = ? AND tbl_name = ?";
        List<String> indexSQLs = DbUtil.getStringListQueryResult(connection, sql, SM_TYPE_INDEX, objectName);
        for (String i : indexSQLs) {
            if (i == null || i.equals("null")) continue;
            result.append("\n");
            result.append(DbSqliteUtil.ensureTrainingSemicolon(i));
            result.append("\n");
        }
        return result.toString();
    }

    private static String ensureTrainingSemicolon(String text) {
        if (text.endsWith(";")) {
            return text;
        }
        return text + ";";
    }
}

