/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.bdbexport.bl;

import de.bright_side.bdbexport.bl.DbExportUtil;
import de.bright_side.bdbexport.bl.DbExporter;
import de.bright_side.bdbexport.bl.DbSqliteUtil;
import de.bright_side.bdbexport.bl.DbUtil;
import de.bright_side.bdbexport.model.CatalogAndSchema;
import de.bright_side.bdbexport.model.InternalObjectExportRequest;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class DbExportViews {
    public List<String> getViewNames(Connection connection, String catalog, String schema) throws Exception {
        return this.getViewNames(connection, new CatalogAndSchema(catalog, schema));
    }

    public List<String> getViewNames(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        DbExporter.DbType dbType = DbUtil.determineDbType(connection);
        SortedSet<String> viewNames = this.getViewNamesSortedAlphabetically(connection, catalogAndSchema);
        return this.sortViewsByDependencies(connection, dbType, catalogAndSchema, viewNames);
    }

    private SortedSet<String> getViewNamesSortedAlphabetically(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        DbExporter.DbType dbType = DbUtil.determineDbType(connection);
        if (DbExportUtil.in(dbType, DbExporter.DbType.H2, DbExporter.DbType.MY_SQL, DbExporter.DbType.MARIA_DB, DbExporter.DbType.SQLITE)) {
            return DbUtil.getDbMetaDataObjectNamesSortedAlphabetically(connection, catalogAndSchema, "VIEW");
        }
        if (dbType == DbExporter.DbType.MS_SQL_SERVER) {
            return this.getMsSqlServerViewNamesSortedAlphabetically(connection, catalogAndSchema);
        }
        throw new Exception("Unknown data base type: '" + (Object)((Object)dbType) + "'");
    }

    private SortedSet<String> getMsSqlServerViewNamesSortedAlphabetically(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        String sql = "select TABLE_NAME from [" + catalogAndSchema.getCatalog() + "].INFORMATION_SCHEMA.VIEWS where TABLE_CATALOG=? and TABLE_SCHEMA=? order by TABLE_NAME";
        List<String> resultList = DbUtil.getStringListQueryResult(connection, sql, catalogAndSchema.getCatalog(), catalogAndSchema.getSchema());
        return new TreeSet<String>(resultList);
    }

    private List<String> sortViewsByDependencies(Connection connection, DbExporter.DbType dataBaseType, CatalogAndSchema catalogAndSchema, Collection<String> viewNames) throws Exception {
        ArrayList<String> returnList = new ArrayList<String>();
        ArrayList<String> useViewNames = new ArrayList<String>();
        for (String i : viewNames) {
            useViewNames.add(i.toUpperCase());
        }
        TreeSet<String> doneViews = new TreeSet<String>();
        TreeSet toDoViews = new TreeSet(useViewNames);
        TreeMap<String, SortedSet<String>> dependencies = new TreeMap<String, SortedSet<String>>();
        for (String i : toDoViews) {
            SortedSet<String> dependentViews = this.getViewsThatThisViewDependsOn(connection, dataBaseType, catalogAndSchema, i, useViewNames);
            dependencies.put(i, dependentViews);
        }
        int lastToDoViewSize = 0;
        while (toDoViews.size() > 0) {
            lastToDoViewSize = toDoViews.size();
            for (String i : toDoViews) {
                if (!doneViews.containsAll((Collection)dependencies.get(i))) continue;
                returnList.add(i);
                doneViews.add(i);
            }
            toDoViews.removeAll(doneViews);
            if (toDoViews.size() == lastToDoViewSize) {
                returnList.add((String)toDoViews.first());
                doneViews.add((String)toDoViews.first());
            }
            toDoViews.removeAll(doneViews);
        }
        return returnList;
    }

    private SortedSet<String> getViewsThatThisViewDependsOn(Connection connection, DbExporter.DbType dataBaseType, CatalogAndSchema catalogAndSchema, String viewName, Collection<String> potentialViewNames) throws Exception {
        TreeSet<String> returnSet = new TreeSet<String>();
        String sql = this.getViewDdl(connection, dataBaseType, catalogAndSchema, viewName).toUpperCase();
        for (String i : potentialViewNames) {
            if (!sql.contains(i.toUpperCase())) continue;
            returnSet.add(i.toUpperCase());
        }
        return returnSet;
    }

    public String getViewDdl(Connection connection, DbExporter.DbType dataBaseType, CatalogAndSchema catalogAndSchema, String viewName) throws Exception {
        if (dataBaseType == DbExporter.DbType.H2) {
            return this.createH2ViewDdl(connection, catalogAndSchema, viewName);
        }
        if (dataBaseType == DbExporter.DbType.MS_SQL_SERVER) {
            return this.createMsSqlServerViewDdl(connection, catalogAndSchema, viewName);
        }
        if (DbExportUtil.in(dataBaseType, DbExporter.DbType.MY_SQL, DbExporter.DbType.MARIA_DB)) {
            return this.createMySqlViewDdl(connection, catalogAndSchema, viewName);
        }
        if (dataBaseType == DbExporter.DbType.SQLITE) {
            return this.createSqliteViewDdl(connection, catalogAndSchema, viewName);
        }
        throw new Exception("Not implemented for db type " + (Object)((Object)dataBaseType));
    }

    private String createMySqlViewDdl(Connection connection, CatalogAndSchema catalogAndSchema, String viewName) throws Exception {
        String result = DbUtil.getStringQueryResultOfColumnWithName(connection, "show create view " + catalogAndSchema.getSchema() + "." + viewName, "Create View");
        return result;
    }

    private String createMsSqlServerViewDdl(Connection connection, CatalogAndSchema catalogAndSchema, String viewName) throws Exception {
        List<String> listResult = DbUtil.getStringListQueryResult(connection, "sp_helptext '[" + catalogAndSchema.getCatalog() + "]." + catalogAndSchema.getSchema() + "." + viewName + "'");
        return DbExportUtil.collectionToString(listResult, "");
    }

    private String createSqliteViewDdl(Connection connection, CatalogAndSchema catalogAndSchema, String viewName) throws Exception {
        return DbSqliteUtil.readSqliteDdlForObject(connection, "view", viewName);
    }

    public void exportViewDdl(InternalObjectExportRequest exportRequest, OutputStream outputStream) throws Exception {
        String result = this.getViewDdl(exportRequest.getConnection(), exportRequest.getDbType(), exportRequest.getCatalogAndSchema(), exportRequest.getObjectName());
        DbExportUtil.write(outputStream, result);
    }

    private String createH2ViewDdl(Connection connection, CatalogAndSchema catalogAndSchema, String viewName) throws Exception {
        String sql = "SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_CATALOG = ? and TABLE_SCHEMA = ? and TABLE_NAME = ?";
        String result = DbUtil.getStringQueryResult(connection, sql, catalogAndSchema.getCatalog(), catalogAndSchema.getSchema(), viewName);
        result = result + ";\n";
        return result;
    }
}

