/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.helper.operators.csv;

import de.brifle.sdk.helper.IsoDateConverter;
import de.brifle.sdk.helper.operators.csv.CsvReceiverRecordType;
import java.util.Date;

public class CsvTelRecord
implements CsvReceiverRecordType {
    private String phoneNumber;
    private String name;
    private Date dateOfBirth;
    private String path;
    private String externalId;

    private CsvTelRecord(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.name = builder.name;
        this.dateOfBirth = builder.dateOfBirth;
        this.path = builder.path;
        this.externalId = builder.externalId;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getName() {
        return this.name;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getPath() {
        return this.path;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String[] getHeader() {
        return new String[]{"external_id", "phone_number", "name", "date_of_birth", "path"};
    }

    @Override
    public String[] getRecord() {
        return new String[]{this.externalId, this.phoneNumber, this.name, IsoDateConverter.toIsoStringShort(this.dateOfBirth), this.path};
    }

    @Override
    public CsvReceiverRecordType setValues(String[] values) {
        if (values.length != 5) {
            throw new IllegalArgumentException("values length must be " + values.length);
        }
        this.externalId = values[0];
        this.phoneNumber = values[1];
        this.name = values[2];
        try {
            this.dateOfBirth = IsoDateConverter.fromIsoStringShort(values[3]);
        }
        catch (Exception e) {
            this.dateOfBirth = null;
        }
        this.path = values[4];
        return this;
    }

    public static final class Builder {
        private String phoneNumber;
        private String name;
        private Date dateOfBirth;
        private String path;
        private String externalId;

        public Builder withPhoneNumber(String val) {
            this.phoneNumber = val;
            return this;
        }

        public Builder withName(String val) {
            this.name = val;
            return this;
        }

        public Builder withDateOfBirth(Date val) {
            this.dateOfBirth = val;
            return this;
        }

        public Builder withPath(String val) {
            this.path = val;
            return this;
        }

        public Builder withExternalId(String val) {
            this.externalId = val;
            return this;
        }

        public CsvTelRecord build() {
            return new CsvTelRecord(this);
        }
    }
}

