/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.helper.csv;

import de.brifle.sdk.helper.Crypto;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CSVBuilder {
    private final byte[] macKey;
    private final String[] header;
    private final List<List<String>> rows = new LinkedList<List<String>>();
    private final CSVFormat csvFormat;
    private final StringWriter sw = new StringWriter();
    private final CSVPrinter printer;
    public static final String HMAC_HEADER = "__HMAC__";

    public CSVBuilder(byte[] macKey, String[] header) throws IOException {
        this.macKey = macKey;
        String[] headerWithHMac = new String[header.length + 1];
        headerWithHMac[0] = HMAC_HEADER;
        System.arraycopy(header, 0, headerWithHMac, 1, header.length);
        this.header = headerWithHMac;
        this.csvFormat = CSVFormat.DEFAULT.builder().setHeader(this.header).setSkipHeaderRecord(false).build();
        this.printer = new CSVPrinter((Appendable)this.sw, this.csvFormat);
    }

    public CSVBuilder(String macKey, String[] header) throws IOException {
        this(Crypto.hexToBytes(macKey), header);
    }

    public CSVBuilder(String[] header) throws NoSuchAlgorithmException, IOException {
        this(Crypto.randomKey(), header);
    }

    public String getHMacKey() {
        return Crypto.bytesToHex(this.macKey);
    }

    public CSVBuilder addRow(String[] row) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        LinkedList<String> newRow = new LinkedList<String>();
        for (String cell : row) {
            newRow.add(cell);
        }
        String hashValue = Stream.of(row).reduce("", (a, b) -> a + b);
        newRow.addFirst(Crypto.hmac(hashValue, Crypto.bytesToHex(this.macKey)));
        this.rows.add(newRow);
        this.printer.printRecord(newRow);
        return this;
    }

    public String build() throws IOException {
        return this.sw.toString();
    }

    public File writeToFile(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter writer = new FileWriter(file);
        writer.write(this.build());
        writer.flush();
        writer.close();
        return file;
    }
}

