/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.api.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.brifle.sdk.api.requests.MailTypes;
import de.brifle.sdk.api.requests.ReceiverRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SendContentRequest {
    private String subject;
    private ReceiverRequest to;
    private List<Content> body;
    @JsonProperty(value="payment_info")
    private PaymentInfo paymentInfo;
    @JsonProperty(value="signature_info")
    private SignatureInfo signatureInfo;
    private String type;

    private SendContentRequest() {
    }

    public String getSubject() {
        return this.subject;
    }

    public ReceiverRequest getTo() {
        return this.to;
    }

    public List<Content> getBody() {
        return this.body;
    }

    public String getType() {
        return this.type;
    }

    public PaymentInfo getPaymentInfo() {
        return this.paymentInfo;
    }

    public SignatureInfo getSignatureInfo() {
        return this.signatureInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class PaymentInfo {
        private PaymentDetails details;
        private boolean payable;

        public PaymentDetails getDetails() {
            return this.details;
        }

        public boolean isPayable() {
            return this.payable;
        }

        public static class PaymentDetails {
            private int amount;
            private String currency;
            private String description;
            @JsonProperty(value="due_date")
            private String dueDate;
            private String iban;
            private String reference;

            protected PaymentDetails() {
            }

            public int getAmount() {
                return this.amount;
            }

            public String getCurrency() {
                return this.currency;
            }

            public String getDescription() {
                return this.description;
            }

            public String getDueDate() {
                return this.dueDate;
            }

            public String getIban() {
                return this.iban;
            }

            public String getReference() {
                return this.reference;
            }
        }
    }

    public static class SignatureInfo {
        @JsonProperty(value="requesting_signer")
        private List<RequestingSigner> requestingSigner = new LinkedList<RequestingSigner>();
        @JsonProperty(value="signature_reference")
        private String signatureReference;

        protected SignatureInfo() {
        }

        private SignatureInfo(Builder builder) {
            this.requestingSigner = builder.requestingSigner;
            this.signatureReference = builder.signatureReference;
        }

        public List<RequestingSigner> getRequestingSigner() {
            return this.requestingSigner;
        }

        public String getSignatureReference() {
            return this.signatureReference;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<RequestingSigner> requestingSigner;
            private String signatureReference;

            protected Builder() {
            }

            public Builder withRequestingSigner(List<RequestingSigner> val) {
                this.requestingSigner = val;
                return this;
            }

            public Builder withSignatureReference(String val) {
                this.signatureReference = val;
                return this;
            }

            private Builder addSignatureReference(String field, String signer) {
                if (this.requestingSigner == null) {
                    this.requestingSigner = new ArrayList<RequestingSigner>();
                }
                RequestingSigner rs = new RequestingSigner();
                rs.field = field;
                rs.signer = signer;
                this.requestingSigner.add(rs);
                return this;
            }

            public Builder addSenderSignature(String field) {
                return this.addSignatureReference(field, "sender");
            }

            public Builder addReceiverSignature(String field) {
                return this.addSignatureReference(field, "receiver");
            }

            public SignatureInfo build() {
                return new SignatureInfo(this);
            }
        }
    }

    public static class Builder {
        private SendContentRequest request = new SendContentRequest();

        public Builder withSubject(String subject) {
            this.request.subject = subject;
            return this;
        }

        public Builder withTo(ReceiverRequest to) {
            this.request.to = to;
            return this;
        }

        public Builder withBody(List<Content> body) {
            this.request.body = body;
            return this;
        }

        public Builder addPdfToBody(String base64EncodedPdf) {
            if (this.request.body == null) {
                this.request.body = new ArrayList<Content>();
            }
            this.request.body.add(Content.pdf(base64EncodedPdf));
            return this;
        }

        public Builder withType(MailTypes type) {
            this.request.type = type.getType();
            return this;
        }

        public Builder withPaymentInfo(PaymentInfo paymentInfo) {
            this.request.paymentInfo = paymentInfo;
            return this;
        }

        public Builder withSignatureInfo(SignatureInfo signatureInfo) {
            this.request.signatureInfo = signatureInfo;
            return this;
        }

        public SendContentRequest build() {
            return this.request;
        }
    }

    public static class RequestingSigner {
        private String field;
        private String signer;

        protected RequestingSigner() {
        }

        public String getField() {
            return this.field;
        }

        public String getSigner() {
            return this.signer;
        }
    }

    public static class Content {
        private String type;
        private String content;

        public String getType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        public static Content pdf(String base64EncodedPdf) {
            Content content = new Content();
            content.type = "application/pdf";
            content.content = base64EncodedPdf;
            return content;
        }
    }
}

