/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.api.requests;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateSignatureReferenceRequest {
    @JsonProperty(value="fields")
    private List<Field> fields;

    protected CreateSignatureReferenceRequest() {
    }

    protected CreateSignatureReferenceRequest(List<Field> fields) {
        this.fields = fields;
    }

    private CreateSignatureReferenceRequest(Builder builder) {
        this.fields = builder.fields;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Field> fields = new LinkedList<Field>();

        private Builder() {
        }

        public Builder addField(String name, String role, String purpose) {
            this.fields.add(new Field(name, role, purpose));
            return this;
        }

        public Builder addField(Field val) {
            this.fields.add(val);
            return this;
        }

        public CreateSignatureReferenceRequest build() {
            return new CreateSignatureReferenceRequest(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Field {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="role")
        private String role;
        @JsonProperty(value="purpose")
        private String purpose;

        protected Field() {
        }

        public Field(String name, String role, String purpose) {
            this.name = name;
            this.role = role;
            this.purpose = purpose;
        }

        public String getName() {
            return this.name;
        }

        public String getRole() {
            return this.role;
        }

        public String getPurpose() {
            return this.purpose;
        }
    }
}

