/*
 * Decompiled with CFR 0.152.
 */
package de.breuco.micronaut.security.token.jwt.validator;

import com.google.firebase.auth.FirebaseToken;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.TokenAuthenticationFactory;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

@Singleton
public class FirebaseAuthenticationFactory
implements TokenAuthenticationFactory<FirebaseToken> {
    private final RolesFinder rolesFinder;

    public FirebaseAuthenticationFactory(RolesFinder rolesFinder) {
        this.rolesFinder = rolesFinder;
    }

    public Optional<Authentication> createAuthentication(FirebaseToken token) {
        return Optional.of(Authentication.build((String)token.getUid(), (Collection)this.rolesFinder.resolveRoles(token.getClaims()), (Map)token.getClaims()));
    }
}

