/*
 * Decompiled with CFR 0.152.
 */
package de.breuco.micronaut.security.token.jwt.validator;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseToken;
import de.breuco.micronaut.security.authentication.FirebaseAuthentication;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.jwt.validator.JwtTokenValidator;
import io.micronaut.security.token.validator.TokenValidator;
import jakarta.inject.Singleton;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Replaces(value=JwtTokenValidator.class)
public class FirebaseTokenValidator
implements TokenValidator {
    public Publisher<Authentication> validateToken(String token, HttpRequest<?> request) {
        try {
            FirebaseToken firebaseToken = FirebaseAuth.getInstance().verifyIdToken(token);
            return Flux.just((Object)new FirebaseAuthentication(firebaseToken));
        }
        catch (Exception e) {
            return Flux.empty();
        }
    }
}

