/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.apns;

import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.PushNotificationResponse;
import com.eatthepath.pushy.apns.util.SimpleApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.eatthepath.pushy.apns.util.TokenUtil;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationFuture;
import de.brendamour.jpasskit.util.Assert;
import de.brendamour.jpasskit.util.CertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKSendPushNotificationUtil
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String EMPTY_PUSH_JSON_STRING = "{}";
    private static final int POOL_SIZE_DEFAULT = 10;
    private ApnsClient client;
    private final Set<String> topics;

    public PKSendPushNotificationUtil(String keyStorePath, char[] keyStorePassword) throws IOException {
        this(keyStorePath, keyStorePassword, 10);
    }

    public PKSendPushNotificationUtil(String keyStorePath, char[] keyStorePassword, int poolSize) throws IOException {
        try (InputStream keyStoreInputStream = CertUtils.toInputStream(keyStorePath);){
            KeyStore keyStore = CertUtils.toKeyStore(keyStoreInputStream, keyStorePassword);
            ImmutablePair<PrivateKey, X509Certificate> certificate = CertUtils.extractCertificateWithKey(keyStore, keyStorePassword);
            this.client = new ApnsClientBuilder().setApnsServer("api.push.apple.com", 443).setClientCredentials((X509Certificate)certificate.getRight(), (PrivateKey)certificate.getLeft(), String.valueOf(keyStorePassword)).setConcurrentConnections(poolSize).build();
            this.topics = CertUtils.extractApnsTopics((X509Certificate)certificate.getRight());
        }
        catch (CertificateException ex) {
            throw new IOException("Failed to load keystore from " + keyStorePath);
        }
    }

    public void setClient(ApnsClient client) {
        this.client = client;
    }

    public PushNotificationFuture<SimpleApnsPushNotification, PushNotificationResponse<SimpleApnsPushNotification>> sendPushNotificationAsync(String pushtoken) {
        LOGGER.debug("Sending Push notification for key: {}", (Object)pushtoken);
        SimpleApnsPayloadBuilder payloadBuilder = new SimpleApnsPayloadBuilder();
        payloadBuilder.setAlertBody(EMPTY_PUSH_JSON_STRING);
        String payload = payloadBuilder.build();
        String token = TokenUtil.sanitizeTokenString((String)pushtoken);
        Assert.state(!this.topics.isEmpty(), "APNS topic is required for sending a push notification", new Object[0]);
        String topic = null;
        if (!this.topics.isEmpty()) {
            topic = this.topics.iterator().next();
            if (this.topics.size() > 1) {
                LOGGER.warn("Multiple APNS topics detected, using {} (first value out of {} available) for sending a push notification", (Object)topic, (Object)this.topics.size());
            }
        }
        SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(token, topic, payload);
        LOGGER.debug("Send Push notification for key: {}", (Object)pushtoken);
        return this.client.sendNotification((ApnsPushNotification)pushNotification);
    }

    @Override
    public void close() throws InterruptedException, ExecutionException {
        if (this.client != null) {
            this.client.close().get();
        }
    }
}

