/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.util;

import de.brendamour.jpasskit.util.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtils {
    private static final String PREFIX_UID = "uid=";
    private static final String TOPIC_OID = "1.2.840.113635.100.6.3.6";

    public static InputStream toInputStream(String path) throws FileNotFoundException {
        File certFile = new File(path);
        if (!certFile.exists()) {
            URL certResource = CertUtils.class.getClassLoader().getResource(path);
            if (certResource == null) {
                throw new FileNotFoundException("File at " + path + " not found");
            }
            certFile = new File(certResource.getFile());
        }
        return new FileInputStream(certFile);
    }

    public static KeyStore toKeyStore(InputStream keyStoreInputStream, char[] keyStorePassword) throws CertificateException {
        Assert.notNull(keyStoreInputStream, "InputStream of key store is mandatory", new Object[0]);
        Assert.notNull(keyStorePassword, "Password for key store is mandatory", new Object[0]);
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(keyStoreInputStream, keyStorePassword);
            return keystore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Failed to load signing information", ex);
        }
    }

    public static X509Certificate toX509Certificate(InputStream certificateInputStream) throws CertificateException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", CertUtils.getProviderName());
            Certificate certificate = certificateFactory.generateCertificate(certificateInputStream);
            if (certificate instanceof X509Certificate) {
                ((X509Certificate)certificate).checkValidity();
                return (X509Certificate)certificate;
            }
            throw new IllegalStateException("The key from the input stream could not be decrypted");
        }
        catch (NoSuchProviderException ex) {
            throw new IllegalStateException("The key from the input stream could not be decrypted", ex);
        }
    }

    public static ImmutablePair<PrivateKey, X509Certificate> extractCertificateWithKey(KeyStore keyStore, char[] keyStorePassword) {
        Assert.notNull(keyStore, "KeyStore is mandatory", new Object[0]);
        Assert.notNull(keyStorePassword, "Password for key store is mandatory", new Object[0]);
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String aliasName = aliases.nextElement();
                Key key = keyStore.getKey(aliasName, keyStorePassword);
                if (!(key instanceof PrivateKey)) continue;
                PrivateKey privateKey = (PrivateKey)key;
                Certificate cert = keyStore.getCertificate(aliasName);
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate certificate = (X509Certificate)cert;
                return ImmutablePair.of((Object)privateKey, (Object)certificate);
            }
            throw new IllegalStateException("No valid key-certificate pair in the key store");
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new IllegalStateException("Failed to extract a valid key-certificate pair from key store", ex);
        }
    }

    public static Set<String> extractApnsTopics(X509Certificate certificate) throws IOException {
        ASN1Primitive extensionValue;
        HashSet<String> topics = new HashSet<String>();
        Arrays.stream(certificate.getSubjectX500Principal().getName().split(",")).filter(p -> p.toLowerCase().startsWith(PREFIX_UID)).findAny().map(p -> p.substring(PREFIX_UID.length())).ifPresent(topics::add);
        byte[] topicExtensionData = certificate.getExtensionValue(TOPIC_OID);
        if (topicExtensionData != null && (extensionValue = JcaX509ExtensionUtils.parseExtensionValue((byte[])topicExtensionData)) instanceof ASN1Sequence) {
            for (Object object : (ASN1Sequence)extensionValue) {
                if (!(object instanceof ASN1String)) continue;
                topics.add(String.valueOf(object));
            }
        }
        return topics;
    }

    public static String getProviderName() {
        return "BC";
    }

    static {
        if (Security.getProvider(CertUtils.getProviderName()) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

