/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.signing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import de.brendamour.jpasskit.PKPass;
import de.brendamour.jpasskit.personalization.PKPersonalization;
import de.brendamour.jpasskit.signing.IPKPassTemplate;
import de.brendamour.jpasskit.signing.PKAbstractSigningUtil;
import de.brendamour.jpasskit.signing.PKPassTemplateFolder;
import de.brendamour.jpasskit.signing.PKSigningException;
import de.brendamour.jpasskit.signing.PKSigningInformation;
import de.brendamour.jpasskit.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.bouncycastle.cms.CMSProcessableFile;
import org.bouncycastle.cms.CMSTypedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PKFileBasedSigningUtil
extends PKAbstractSigningUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PKFileBasedSigningUtil() {
        super(new ObjectMapper());
    }

    public PKFileBasedSigningUtil(ObjectWriter objectWriter) {
        super(objectWriter);
    }

    @Deprecated
    public PKFileBasedSigningUtil(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public byte[] createSignedAndZippedPkPassArchive(PKPass pass, IPKPassTemplate passTemplate, PKSigningInformation signingInformation) throws PKSigningException {
        return this.createSignedAndZippedPersonalizedPkPassArchive(pass, null, passTemplate, signingInformation);
    }

    @Override
    public byte[] createSignedAndZippedPersonalizedPkPassArchive(PKPass pass, PKPersonalization personalization, IPKPassTemplate passTemplate, PKSigningInformation signingInformation) throws PKSigningException {
        File tempPassDir = Files.createTempDir();
        try {
            passTemplate.provisionPassAtDirectory(tempPassDir);
        }
        catch (IOException e) {
            throw new PKSigningException("Error when provisioning template", e);
        }
        this.createPassJSONFile(pass, tempPassDir);
        if (personalization != null) {
            this.createPersonalizationJSONFile(personalization, tempPassDir);
        }
        File manifestJSONFile = this.createManifestJSONFile(tempPassDir);
        this.signManifestFileAndWriteToDirectory(tempPassDir, manifestJSONFile, signingInformation);
        byte[] zippedPass = this.createZippedPassAndReturnAsByteArray(tempPassDir);
        try {
            FileUtils.deleteDirectory((File)tempPassDir);
        }
        catch (IOException e) {
            LOGGER.warn("Removing the temporary directory failed", (Throwable)e);
        }
        return zippedPass;
    }

    public byte[] createSignedAndZippedPkPassArchive(PKPass pass, URL fileUrlOfTemplateDirectory, PKSigningInformation signingInformation) throws PKSigningException {
        try {
            return this.createSignedAndZippedPkPassArchive(pass, new PKPassTemplateFolder(fileUrlOfTemplateDirectory), signingInformation);
        }
        catch (UnsupportedEncodingException e) {
            throw new PKSigningException(e);
        }
    }

    public byte[] createSignedAndZippedPkPassArchive(PKPass pass, String pathToTemplateDirectory, PKSigningInformation signingInformation) throws PKSigningException {
        return this.createSignedAndZippedPkPassArchive(pass, new PKPassTemplateFolder(pathToTemplateDirectory), signingInformation);
    }

    public void signManifestFileAndWriteToDirectory(File temporaryPassDirectory, File manifestJSONFile, PKSigningInformation signingInformation) throws PKSigningException {
        Assert.notNull(temporaryPassDirectory, "Temporary directory is mandatory", new Object[0]);
        Assert.notNull(manifestJSONFile, "Manifest JSON file is mandatory", new Object[0]);
        File signatureFile = new File(temporaryPassDirectory.getAbsolutePath() + File.separator + "signature");
        try (FileOutputStream signatureOutputStream = new FileOutputStream(signatureFile);){
            CMSProcessableFile content = new CMSProcessableFile(manifestJSONFile);
            signatureOutputStream.write(this.signManifestUsingContent(signingInformation, (CMSTypedData)content));
        }
        catch (IOException e) {
            throw new PKSigningException("Error when writing signature to folder", e);
        }
    }

    private void createPassJSONFile(PKPass pass, File tempPassDir) throws PKSigningException {
        try {
            File passJSONFile = new File(tempPassDir.getAbsolutePath() + File.separator + "pass.json");
            this.objectWriter.writeValue(passJSONFile, (Object)pass);
        }
        catch (IOException e) {
            throw new PKSigningException("Error when writing pass.json", e);
        }
    }

    private void createPersonalizationJSONFile(PKPersonalization personalization, File tempPassDir) throws PKSigningException {
        try {
            File personalizationJSONFile = new File(tempPassDir.getAbsolutePath() + File.separator + "personalization.json");
            this.objectWriter.writeValue(personalizationJSONFile, (Object)personalization);
        }
        catch (IOException e) {
            throw new PKSigningException("Error when writing personalization.json", e);
        }
    }

    private File createManifestJSONFile(File tempPassDir) throws PKSigningException {
        try {
            File manifestJSONFile = new File(tempPassDir.getCanonicalPath() + File.separator + "manifest.json");
            Map<String, String> fileWithHashMap = this.hashFiles(tempPassDir, Hashing.sha1());
            this.objectWriter.writeValue(manifestJSONFile, fileWithHashMap);
            return manifestJSONFile;
        }
        catch (IOException e) {
            throw new PKSigningException("Error when writing manifest.json", e);
        }
    }

    private Map<String, String> hashFiles(File tempPassDir, HashFunction hashFunction) throws PKSigningException {
        HashMap<String, String> fileWithHashMap = new HashMap<String, String>();
        try {
            String base = tempPassDir.getCanonicalPath() + File.separator;
            for (File file : FileUtils.listFiles((File)tempPassDir, (IOFileFilter)new RegexFileFilter("^(?!\\.).*"), (IOFileFilter)TrueFileFilter.TRUE)) {
                HashCode hash = Files.hash((File)file, (HashFunction)hashFunction);
                fileWithHashMap.put(this.getRelativePathOfZipEntry(file.getCanonicalPath(), base), Hex.encodeHexString((byte[])hash.asBytes()));
            }
        }
        catch (IOException e) {
            throw new PKSigningException("Error when hashing files", e);
        }
        return fileWithHashMap;
    }

    private byte[] createZippedPassAndReturnAsByteArray(File tempPassDir) throws PKSigningException {
        ByteArrayOutputStream byteArrayOutputStreamForZippedPass = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStreamForZippedPass);){
            String base = tempPassDir.getCanonicalPath() + File.separator;
            for (File file : FileUtils.listFiles((File)tempPassDir, (IOFileFilter)new RegexFileFilter("^(?!\\.).*"), (IOFileFilter)TrueFileFilter.TRUE)) {
                FileInputStream fileInputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    ZipEntry entry = new ZipEntry(this.getRelativePathOfZipEntry(file.getCanonicalPath(), base));
                    zipOutputStream.putNextEntry(entry);
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new PKSigningException("Error when creating a zip package", e);
        }
        return byteArrayOutputStreamForZippedPass.toByteArray();
    }
}

