/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.passes;

import de.brendamour.jpasskit.IPKBuilder;
import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.PKField;
import de.brendamour.jpasskit.PKFieldBuilder;
import de.brendamour.jpasskit.enums.PKPassType;
import de.brendamour.jpasskit.enums.PKTransitType;
import de.brendamour.jpasskit.passes.PKBoardingPass;
import de.brendamour.jpasskit.passes.PKCoupon;
import de.brendamour.jpasskit.passes.PKEventTicket;
import de.brendamour.jpasskit.passes.PKGenericPass;
import de.brendamour.jpasskit.passes.PKStoreCard;
import de.brendamour.jpasskit.util.BuilderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

public class PKGenericPassBuilder
implements IPKValidateable,
IPKBuilder<PKGenericPass> {
    private PKPassType passType;
    private List<PKFieldBuilder> headerFields;
    private List<PKFieldBuilder> primaryFields;
    private List<PKFieldBuilder> secondaryFields;
    private List<PKFieldBuilder> auxiliaryFields;
    private List<PKFieldBuilder> backFields;
    private PKTransitType transitType;

    protected PKGenericPassBuilder() {
        this(PKPassType.PKGenericPass);
    }

    protected PKGenericPassBuilder(PKPassType passType) {
        this.passType(passType);
        this.headerFields = new CopyOnWriteArrayList<PKFieldBuilder>();
        this.primaryFields = new CopyOnWriteArrayList<PKFieldBuilder>();
        this.secondaryFields = new CopyOnWriteArrayList<PKFieldBuilder>();
        this.auxiliaryFields = new CopyOnWriteArrayList<PKFieldBuilder>();
        this.backFields = new CopyOnWriteArrayList<PKFieldBuilder>();
    }

    public List<PKFieldBuilder> getHeaderFieldBuilders() {
        return this.headerFields;
    }

    public List<PKFieldBuilder> getPrimaryFieldBuilders() {
        return this.primaryFields;
    }

    public List<PKFieldBuilder> getSecondaryFieldBuilders() {
        return this.secondaryFields;
    }

    public List<PKFieldBuilder> getAuxiliaryFieldBuilders() {
        return this.auxiliaryFields;
    }

    public List<PKFieldBuilder> getBackFieldBuilders() {
        return this.backFields;
    }

    public PKGenericPassBuilder of(PKGenericPass source) {
        this.passType = PKGenericPassBuilder.toPassType(source);
        if (source != null) {
            this.headerFields = BuilderUtils.toFieldBuilderList(source.headerFields);
            this.primaryFields = BuilderUtils.toFieldBuilderList(source.primaryFields);
            this.secondaryFields = BuilderUtils.toFieldBuilderList(source.secondaryFields);
            this.auxiliaryFields = BuilderUtils.toFieldBuilderList(source.auxiliaryFields);
            this.backFields = BuilderUtils.toFieldBuilderList(source.backFields);
        }
        return this;
    }

    public PKGenericPassBuilder of(PKBoardingPass source) {
        if (source != null) {
            this.transitType = source.transitType;
        }
        return this.of((PKGenericPass)source);
    }

    public PKPassType getPassType() {
        return this.passType;
    }

    public PKGenericPassBuilder passType(PKPassType passType) {
        this.passType = passType;
        return this;
    }

    public PKGenericPassBuilder headerFieldBuilder(PKFieldBuilder field) {
        this.headerFields.add(field);
        return this;
    }

    public PKGenericPassBuilder headerField(PKField field) {
        return this.headerFieldBuilder(PKGenericPassBuilder.toBuilder(field));
    }

    public PKGenericPassBuilder headerFields(List<PKField> fields) {
        if (BuilderUtils.isEmpty(fields)) {
            this.headerFields.clear();
            return this;
        }
        fields.forEach(this::headerField);
        return this;
    }

    public PKGenericPassBuilder primaryFieldBuilder(PKFieldBuilder field) {
        this.primaryFields.add(field);
        return this;
    }

    public PKGenericPassBuilder primaryField(PKField field) {
        return this.primaryFieldBuilder(PKGenericPassBuilder.toBuilder(field));
    }

    public PKGenericPassBuilder primaryFields(List<PKField> fields) {
        if (BuilderUtils.isEmpty(fields)) {
            this.primaryFields.clear();
            return this;
        }
        fields.forEach(this::primaryField);
        return this;
    }

    public PKGenericPassBuilder secondaryFieldBuilder(PKFieldBuilder field) {
        this.secondaryFields.add(field);
        return this;
    }

    public PKGenericPassBuilder secondaryField(PKField field) {
        return this.secondaryFieldBuilder(PKGenericPassBuilder.toBuilder(field));
    }

    public PKGenericPassBuilder secondaryFields(List<PKField> fields) {
        if (BuilderUtils.isEmpty(fields)) {
            this.secondaryFields.clear();
            return this;
        }
        fields.forEach(this::secondaryField);
        return this;
    }

    public PKGenericPassBuilder auxiliaryFieldBuilder(PKFieldBuilder field) {
        this.auxiliaryFields.add(field);
        return this;
    }

    public PKGenericPassBuilder auxiliaryField(PKField field) {
        return this.auxiliaryFieldBuilder(PKGenericPassBuilder.toBuilder(field));
    }

    public PKGenericPassBuilder auxiliaryFields(List<PKField> fields) {
        if (BuilderUtils.isEmpty(fields)) {
            this.auxiliaryFields.clear();
            return this;
        }
        fields.forEach(this::auxiliaryField);
        return this;
    }

    public PKGenericPassBuilder backFieldBuilder(PKFieldBuilder field) {
        this.backFields.add(field);
        return this;
    }

    public PKGenericPassBuilder backField(PKField field) {
        return this.backFieldBuilder(PKGenericPassBuilder.toBuilder(field));
    }

    public PKGenericPassBuilder backFields(List<PKField> fields) {
        if (BuilderUtils.isEmpty(fields)) {
            this.backFields.clear();
            return this;
        }
        fields.forEach(this::backField);
        return this;
    }

    public PKGenericPassBuilder transitType(PKTransitType transitType) {
        this.transitType = transitType;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        Stream.of(this.primaryFields, this.secondaryFields, this.headerFields, this.backFields, this.auxiliaryFields).flatMap(Collection::stream).filter(f -> !f.isValid()).map(PKFieldBuilder::getValidationErrors).flatMap(Collection::stream).forEach(validationErrors::add);
        if (this.passType == PKPassType.PKBoardingPass && this.transitType == null) {
            validationErrors.add("TransitType is not set");
        }
        return validationErrors;
    }

    private <T extends PKGenericPass> T buildPass(T dest) {
        dest.headerFields = BuilderUtils.buildAll(this.headerFields);
        dest.primaryFields = BuilderUtils.buildAll(this.primaryFields);
        dest.secondaryFields = BuilderUtils.buildAll(this.secondaryFields);
        dest.auxiliaryFields = BuilderUtils.buildAll(this.auxiliaryFields);
        dest.backFields = BuilderUtils.buildAll(this.backFields);
        return dest;
    }

    @Override
    public PKGenericPass build() {
        if (PKPassType.PKBoardingPass == this.passType) {
            return this.buildBoardingPass();
        }
        if (PKPassType.PKCoupon == this.passType) {
            return this.buildCoupon();
        }
        if (PKPassType.PKEventTicket == this.passType) {
            return this.buildEventTicket();
        }
        if (PKPassType.PKStoreCard == this.passType) {
            return this.buildStoreCard();
        }
        return this.buildPass(new PKGenericPass());
    }

    public PKBoardingPass buildBoardingPass() {
        PKBoardingPass pass = this.buildPass(new PKBoardingPass());
        pass.transitType = this.transitType;
        return pass;
    }

    public PKCoupon buildCoupon() {
        return this.buildPass(new PKCoupon());
    }

    public PKEventTicket buildEventTicket() {
        return this.buildPass(new PKEventTicket());
    }

    public PKStoreCard buildStoreCard() {
        return this.buildPass(new PKStoreCard());
    }

    private static PKFieldBuilder toBuilder(PKField field) {
        return PKField.builder(field);
    }

    private static PKPassType toPassType(PKGenericPass pass) {
        if (pass instanceof PKBoardingPass) {
            return PKPassType.PKBoardingPass;
        }
        if (pass instanceof PKCoupon) {
            return PKPassType.PKCoupon;
        }
        if (pass instanceof PKEventTicket) {
            return PKPassType.PKEventTicket;
        }
        if (pass instanceof PKStoreCard) {
            return PKPassType.PKStoreCard;
        }
        return PKPassType.PKGenericPass;
    }
}

