/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.passes;

import com.google.common.collect.Lists;
import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.PKField;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PKGenericPass
implements IPKValidateable {
    private static final long serialVersionUID = 3408389190364251557L;
    protected List<PKField> headerFields;
    protected List<PKField> primaryFields;
    protected List<PKField> secondaryFields;
    protected List<PKField> auxiliaryFields;
    protected List<PKField> backFields;

    public void addPrimaryField(PKField field) {
        if (this.primaryFields == null) {
            this.primaryFields = new CopyOnWriteArrayList<PKField>();
        }
        this.primaryFields.add(field);
    }

    public List<PKField> getPrimaryFields() {
        return this.primaryFields;
    }

    public void setPrimaryFields(List<PKField> primaryFields) {
        this.primaryFields = primaryFields;
    }

    public void addSecondaryField(PKField field) {
        if (this.secondaryFields == null) {
            this.secondaryFields = new CopyOnWriteArrayList<PKField>();
        }
        this.secondaryFields.add(field);
    }

    public List<PKField> getSecondaryFields() {
        return this.secondaryFields;
    }

    public void setSecondaryFields(List<PKField> secondaryFields) {
        this.secondaryFields = secondaryFields;
    }

    public void addAuxiliaryField(PKField field) {
        if (this.auxiliaryFields == null) {
            this.auxiliaryFields = new CopyOnWriteArrayList<PKField>();
        }
        this.auxiliaryFields.add(field);
    }

    public List<PKField> getAuxiliaryFields() {
        return this.auxiliaryFields;
    }

    public void setAuxiliaryFields(List<PKField> auxiliaryFields) {
        this.auxiliaryFields = auxiliaryFields;
    }

    public void addBackField(PKField field) {
        if (this.backFields == null) {
            this.backFields = new CopyOnWriteArrayList<PKField>();
        }
        this.backFields.add(field);
    }

    public List<PKField> getBackFields() {
        return this.backFields;
    }

    public void setBackFields(List<PKField> backFields) {
        this.backFields = backFields;
    }

    public void addHeaderField(PKField field) {
        if (this.headerFields == null) {
            this.headerFields = new CopyOnWriteArrayList<PKField>();
        }
        this.headerFields.add(field);
    }

    public List<PKField> getHeaderFields() {
        return this.headerFields;
    }

    public void setHeaderFields(List<PKField> headerFields) {
        this.headerFields = headerFields;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        ArrayList<String> validationErrors = new ArrayList<String>();
        ArrayList lists = Lists.newArrayList();
        lists.add(this.primaryFields);
        lists.add(this.secondaryFields);
        lists.add(this.headerFields);
        lists.add(this.backFields);
        lists.add(this.auxiliaryFields);
        for (List list : lists) {
            if (list == null) continue;
            for (PKField pkField : list) {
                if (pkField.isValid()) continue;
                validationErrors.addAll(pkField.getValidationErrors());
            }
        }
        return validationErrors;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

